/*
 * Decompiled with CFR 0.152.
 */
package freak.rinterface.control;

import freak.core.control.BatchProcessor;
import freak.core.control.FreakFile;
import freak.core.control.Schedule;
import freak.core.modulesupport.PersistenceManager;
import freak.gui.JButtonFactory;
import freak.gui.graph.EditorDialog;
import freak.gui.runframe.AbstractRunFrame;
import freak.gui.runframe.RunFrame;
import freak.gui.runframe.RunFrameLR;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.rinterface.control.LogRegInterface;
import freak.rinterface.model.ScheduleConfigurator;
import jargs.gnu.CmdLineParser;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class RFreak {
    private static boolean logReg = true;
    private static int actionModifierKey;
    private static int DEBUG_LEVEL;
    static AbstractRunFrame f;

    static {
        DEBUG_LEVEL = 0;
    }

    public static void viewFilenameInTitle(String s) {
        if (f != null) {
            f.viewFilenameInTitle(s);
        }
    }

    public static void main(String[] arguments) throws Exception {
        System.out.println("der richtige Launcher");
    }

    public static void showEditorDialog() {
        Schedule schedule = ScheduleConfigurator.createDefaultSchedule();
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        EditorDialog gred = new EditorDialog(dialog, schedule);
        gred.setVisible(true);
    }

    public static void showEditorDialog(Schedule schedule) {
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        EditorDialog gred = new EditorDialog(dialog, schedule);
        gred.setVisible(true);
    }

    public static void showScheduleEditor() {
        Schedule schedule = ScheduleConfigurator.createDefaultSchedule();
        RFreak.showScheduleEditor(schedule);
    }

    public static void showScheduleEditor(String schedulePath) {
        RunFrame runframe = new RunFrame();
        Schedule schedule = ScheduleConfigurator.createDefaultSchedule();
        try {
            runframe.runControl.fromFile(FreakFile.read(new FileInputStream(schedulePath)));
            schedule = runframe.runControl.getSchedule();
        }
        catch (Exception exc) {
            schedule = ScheduleConfigurator.createDefaultSchedule();
            System.out.println("Error loading " + schedulePath + ". Will use a default schedule.");
        }
        runframe.runControl.setNewSchedule(schedule);
        ScheduleEditor sced = new ScheduleEditor(runframe, schedule);
        sced.setRMode();
        runframe.setScheduleEditor(sced);
        runframe.runControl.setNewSchedule(schedule);
        sced.setVisible(true);
    }

    public static void showScheduleEditor(Schedule schedule) {
        RunFrame runframe = new RunFrame();
        runframe.runControl.setNewSchedule(schedule);
        ScheduleEditor sced = new ScheduleEditor(runframe, schedule);
        sced.setRMode();
        runframe.setScheduleEditor(sced);
        runframe.runControl.setNewSchedule(schedule);
        sced.setVisible(true);
    }

    public static void rMain(String[] arguments) throws Exception {
        File loadFile = null;
        File saveFile = null;
        File[] tempFiles = null;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option fileOption = parser.addStringOption('f', "temp-file-base");
        CmdLineParser.Option intervalOption = parser.addIntegerOption('i', "temp-file-interval");
        CmdLineParser.Option debugOption = parser.addIntegerOption('d', "debug-level");
        try {
            parser.parse(arguments);
        }
        catch (CmdLineParser.IllegalOptionValueException e) {
            RFreak.printUsage();
            return;
        }
        catch (CmdLineParser.UnknownOptionException e) {
            RFreak.printUsage();
            return;
        }
        String tempFileBase = (String)parser.getOptionValue(fileOption);
        if (tempFileBase != null) {
            File tempFile1 = new File(String.valueOf(tempFileBase) + "1.freak");
            File tempFile2 = new File(String.valueOf(tempFileBase) + "2.freak");
            tempFiles = new File[]{tempFile1, tempFile2};
        }
        DEBUG_LEVEL = parser.getOptionValue(debugOption) != null ? (Integer)parser.getOptionValue(debugOption) : 4;
        long interval = 1000 * (parser.getOptionValue(debugOption) != null ? (Integer)parser.getOptionValue(intervalOption) : 3600);
        arguments = parser.getRemainingArgs();
        if (arguments.length > 0) {
            loadFile = new File(arguments[0]);
        }
        if (arguments.length > 1) {
            saveFile = new File(arguments[1]);
        }
        if (arguments.length > 2) {
            RFreak.printUsage();
            return;
        }
        Locale.setDefault(Locale.US);
        PersistenceManager.init();
        if (loadFile == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        String lookAndFeel = UIManager.getLookAndFeel().getName();
                        actionModifierKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                        if (lookAndFeel.equals("Mac OS X Aqua")) {
                            JButtonFactory.activateBugFix();
                        }
                        f = logReg ? new RunFrameLR() : new RunFrame();
                        f.setLocationRelativeTo(null);
                        f.setVisible(true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        } else if (logReg) {
            LogRegInterface batchProcessor = new LogRegInterface(loadFile, saveFile, tempFiles, interval);
            batchProcessor.run();
        } else {
            BatchProcessor batchProcessor = new BatchProcessor(loadFile, saveFile, tempFiles, interval);
            batchProcessor.run();
        }
    }

    private static void printUsage() {
        System.out.println("freak [options]\nfreak [options] loadSchedule\nfreak [options] loadSchedule saveSchedule\n\nOptions:\n  -d, --debug-level:           verbosity; default = 4  -f, --temp-file-base:        start of file name for backup files  -i, --temp-file-interval:    backup interval in seconds; default = 3600");
    }

    public static int getActionModifierKey() {
        return actionModifierKey;
    }

    public static void debug(String message, int level) {
        if (level <= DEBUG_LEVEL) {
            System.out.println(message);
        }
    }
}

