/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class BreitWigner
extends AbstractContinousDistribution {
    protected double mean;
    protected double gamma;
    protected double cut;
    protected static BreitWigner shared = new BreitWigner(1.0, 0.2, 1.0, AbstractDistribution.makeDefaultGenerator());

    public BreitWigner(double mean, double gamma, double cut, RandomElement randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(mean, gamma, cut);
    }

    public double nextDouble() {
        return this.nextDouble(this.mean, this.gamma, this.cut);
    }

    public double nextDouble(double mean, double gamma, double cut) {
        if (gamma == 0.0) {
            return mean;
        }
        if (cut == Double.NEGATIVE_INFINITY) {
            double rval = 2.0 * this.randomGenerator.raw() - 1.0;
            double displ = 0.5 * gamma * Math.tan(rval * 1.5707963267948966);
            return mean + displ;
        }
        double val = Math.atan(2.0 * cut / gamma);
        double rval = 2.0 * this.randomGenerator.raw() - 1.0;
        double displ = 0.5 * gamma * Math.tan(rval * val);
        return mean + displ;
    }

    public void setState(double mean, double gamma, double cut) {
        this.mean = mean;
        this.gamma = gamma;
        this.cut = cut;
    }

    public static double staticNextDouble(double mean, double gamma, double cut) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            return shared.nextDouble(mean, gamma, cut);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.mean + "," + this.gamma + "," + this.cut + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomGenerator) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

