/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.GenerationIndex;
import freak.core.control.RunIndex;
import freak.core.control.Schedule;
import freak.core.util.StreamCopy;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Replay
implements Serializable {
    private static double defaultCheckPointInterval = 1.2;
    private static long defaultMaxMemoryUsage = 2000000L;
    private static long defaultSingleScheduleMemoryThreshhold = 200000L;
    private double checkPointInterval = defaultCheckPointInterval;
    private int runEndCheckPointInterval = 1;
    private long maxMemoryUsage = defaultMaxMemoryUsage;
    private long singleScheduleMemoryThreshold = defaultSingleScheduleMemoryThreshhold;
    private boolean alsoStripRunEndPoints = false;
    private int estimatedMemoryRequirement;
    private double lastCheckPointProcessingTime;
    private GenerationIndex lastPoint;
    private SortedMap lastPointInRuns = new TreeMap();
    private SortedMap lastPointInBatches = new TreeMap();
    private SortedMap checkPoints = new TreeMap();
    private SortedSet editPoints = new TreeSet();

    public boolean containsPoint(GenerationIndex timeIndex) {
        GenerationIndex runEnd = this.getLastPointInRun(timeIndex.toRunIndex());
        if (runEnd == null) {
            return false;
        }
        return runEnd.generation >= timeIndex.generation;
    }

    Schedule getCheckPointFor(GenerationIndex timeIndex) {
        try {
            SortedMap head = Replay.upTo(this.checkPoints, timeIndex);
            Object key = head.lastKey();
            CheckPoint point = (CheckPoint)head.get(key);
            Schedule copy = (Schedule)StreamCopy.copy(point.schedule);
            return copy;
        }
        catch (NotSerializableException exc) {
            throw new RuntimeException(exc);
        }
    }

    boolean isEditPoint(GenerationIndex timeIndex) {
        return this.editPoints.contains(timeIndex);
    }

    public GenerationIndex getLastPointInBatch(int batch) {
        return (GenerationIndex)this.lastPointInBatches.get(new Integer(batch));
    }

    public GenerationIndex getLastPointInRun(RunIndex runIndex) {
        return (GenerationIndex)this.lastPointInRuns.get(runIndex);
    }

    public GenerationIndex getLastPoint() {
        return this.lastPoint;
    }

    void addPoint(Schedule activeSchedule, boolean isEditPoint) {
        GenerationIndex timeIndex;
        activeSchedule.timeController.timeOutStart();
        this.lastPoint = timeIndex = activeSchedule.getCurrentTimeIndex();
        this.lastPointInRuns.put(timeIndex.toRunIndex(), timeIndex);
        this.lastPointInBatches.put(new Integer(timeIndex.batch), timeIndex);
        double currentTime = activeSchedule.timeController.getProcessingTime();
        if (isEditPoint) {
            this.createCheckPoint(timeIndex, activeSchedule);
            this.editPoints.add(timeIndex);
        }
        activeSchedule.timeController.timeOutStop();
    }

    void removeAllSince(GenerationIndex timeIndex) {
        RunIndex runIndex = timeIndex.toRunIndex();
        int batch = timeIndex.batch;
        this.checkPoints = new TreeMap(Replay.upTo(this.checkPoints, timeIndex));
        this.editPoints = new TreeSet(Replay.upTo(this.editPoints, timeIndex));
        this.lastPointInBatches = new TreeMap(Replay.upTo(this.lastPointInBatches, batch));
        this.lastPointInBatches.put(new Integer(batch), timeIndex);
        this.lastPointInRuns = new TreeMap(Replay.upTo(this.lastPointInRuns, runIndex));
        this.lastPointInRuns.put(runIndex, timeIndex);
        this.lastPoint = timeIndex;
        this.recreateProcessingInformation();
    }

    private void trimMemory() {
        while ((long)this.estimatedMemoryRequirement > this.maxMemoryUsage) {
            try {
                this.removeEverySecondCheckpoint(this.alsoStripRunEndPoints);
                if (this.alsoStripRunEndPoints) {
                    this.runEndCheckPointInterval *= 2;
                } else {
                    this.checkPointInterval *= 2.0;
                }
                this.recreateProcessingInformation();
            }
            catch (NoSuchElementException exc) {
                if (!this.alsoStripRunEndPoints) {
                    this.alsoStripRunEndPoints = true;
                    this.checkPointInterval = Double.POSITIVE_INFINITY;
                    continue;
                }
                this.runEndCheckPointInterval = Integer.MAX_VALUE;
                break;
            }
        }
    }

    private void removeEverySecondCheckpoint(boolean includeRunEndPoints) {
        Iterator i = this.checkPoints.keySet().iterator();
        int n = 1;
        boolean anyRemoved = false;
        while (i.hasNext()) {
            Object timeIndex = i.next();
            if (n % 2 == 0) {
                boolean editPoint = this.editPoints.contains(timeIndex);
                boolean runEndPoint = ((CheckPoint)this.checkPoints.get(timeIndex)).schedule.isCurrentRunFinished();
                if (!(editPoint || runEndPoint && !includeRunEndPoints)) {
                    i.remove();
                    anyRemoved = true;
                } else {
                    n = 1;
                }
            }
            ++n;
        }
        if (!anyRemoved) {
            throw new NoSuchElementException();
        }
    }

    private void createCheckPoint(GenerationIndex timeIndex, Schedule schedule) {
        try {
            byte[] streamedSchedule = StreamCopy.serialize(schedule);
            Schedule copy = (Schedule)StreamCopy.read(streamedSchedule);
            int streamLength = streamedSchedule.length;
            this.estimatedMemoryRequirement += streamLength;
            copy.timeController.stopCounting();
            CheckPoint point = new CheckPoint(copy, streamedSchedule.length);
            this.checkPoints.put(timeIndex, point);
            this.lastCheckPointProcessingTime = schedule.timeController.getProcessingTime();
            if ((long)streamLength > this.singleScheduleMemoryThreshold) {
                this.checkPointInterval = Double.POSITIVE_INFINITY;
                this.runEndCheckPointInterval = Integer.MAX_VALUE;
            }
        }
        catch (NotSerializableException exc) {
            RuntimeException r = new RuntimeException("Some part of Schedule, probably a Module, is not Serializable.");
            r.initCause(exc);
            throw r;
        }
    }

    private void recreateProcessingInformation() {
        Iterator i = this.checkPoints.values().iterator();
        CheckPoint point = null;
        this.estimatedMemoryRequirement = 0;
        while (i.hasNext()) {
            point = (CheckPoint)i.next();
            this.estimatedMemoryRequirement += point.memoryRequirement;
        }
        this.lastCheckPointProcessingTime = point == null ? 0.0 : point.schedule.timeController.getProcessingTime();
    }

    private static SortedSet upTo(SortedSet set, GenerationIndex generationIndex) {
        return set.headSet(generationIndex.nextGeneration());
    }

    private static SortedMap upTo(SortedMap map, GenerationIndex generationIndex) {
        return map.headMap(generationIndex.nextGeneration());
    }

    private static SortedMap upTo(SortedMap map, RunIndex runIndex) {
        return map.headMap(runIndex.nextRun());
    }

    private static SortedMap upTo(SortedMap map, int batch) {
        return map.headMap(new Integer(batch + 1));
    }

    private static class CheckPoint
    implements Serializable {
        Schedule schedule;
        int memoryRequirement;

        public CheckPoint(Schedule schedule, int memoryRequirement) {
            this.schedule = schedule;
            this.memoryRequirement = memoryRequirement;
        }
    }
}

