/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.permutation;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;

public class Sort_INV
extends AbstractStaticSingleObjectiveFitnessFunction {
    public Sort_INV(Schedule schedule) {
        super(schedule);
    }

    protected double evaluate(Genotype genotype) {
        return this.calculateINV((PermutationGenotype)genotype);
    }

    public String getName() {
        return "Sorting with measure INV";
    }

    public String getDescription() {
        return "The sorting problem can be viewed as an optimization problem: the sortedness of a sequence has to be maximized. We assume a_1 < a_2 < ... < a_n, so the optimal permutation is the identity. \nThe measure of sortedness used by this fitness function is INV.\nINV(pi) measures the number of pairs (i,j) such that pi(i) < pi(j) (pairs in correct order).";
    }

    private int calculateINV(PermutationGenotype gt) {
        int[] a = gt.getIntArray();
        int count = 0;
        int i = 0;
        while (i < a.length - 1) {
            int j = i + 1;
            while (j < a.length) {
                if (a[i] < a[j]) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int[] a = new int[n];
        int i = 0;
        while (i < n) {
            a[i] = i;
            ++i;
        }
        return new PermutationGenotype(a);
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int n = ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        return n * (n - 1) / 2;
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }
}

