/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class SP
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int k = 1;

    public SP(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        int cardinality = bs.cardinality();
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int maxOnes = (int)Math.ceil((double)n / (double)(3 * this.k)) * this.k;
        if (cardinality % this.k == 0 && cardinality <= maxOnes) {
            BitSet tbs = new BitSet(n);
            tbs.set(0, cardinality);
            if (bs.equals(tbs)) {
                return n * (cardinality + 1);
            }
        }
        return n - cardinality;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        return (double)n * (Math.ceil((double)n / (double)(3 * this.k)) * (double)this.k + 1.0);
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(n);
        bs.set(0, (int)Math.ceil((double)n / (double)(3 * this.k)) * this.k);
        return new BitStringGenotype(bs, n);
    }

    public void setPropertyK(Integer k) {
        if (k > 0) {
            this.k = k;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForK() {
        return "k";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    public String getDescription() {
        return "For Short Path k there is a kind of short path starting in 0^n. All points on the path are of the form 1^i0^(n-i) and are formed of n/(3k) consecutive blocks of length k. If a block consists only of 1-bits and this holds for all blocks to its left, too, this is rewarded by n. For all points not on the path, each 1-bit in the string reduces the function value by 1 making the first point of the path easy to find. Obviously, the expected optimization time E(T) will increase with k.";
    }

    public String getName() {
        return "Short Path k";
    }
}

