/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class XMLOutputter
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: XMLOutputter.java,v $ $Revision: 1.91 $ $Date: 2003/04/08 04:57:45 $ $Name: jdom_1_0_b9_rc2 $";
    private boolean omitDeclaration = false;
    private String encoding = "UTF-8";
    private boolean omitEncoding = false;
    private static final String STANDARD_INDENT = "  ";
    private static final String STANDARD_LINE_SEPARATOR = "\r\n";
    Format noFormatting = new Format();
    Format defaultFormat;
    Format currentFormat = this.defaultFormat = new Format();

    public XMLOutputter() {
    }

    public XMLOutputter(String indent) {
        this.setIndent(indent);
    }

    public XMLOutputter(String indent, boolean newlines) {
        this.setIndent(indent);
        this.setNewlines(newlines);
    }

    public XMLOutputter(String indent, boolean newlines, String encoding) {
        this.setEncoding(encoding);
        this.setIndent(indent);
        this.setNewlines(newlines);
    }

    public XMLOutputter(XMLOutputter that) {
        this.encoding = that.encoding;
        this.omitDeclaration = that.omitDeclaration;
        this.omitEncoding = that.omitEncoding;
        this.defaultFormat = (Format)that.defaultFormat.clone();
    }

    public void setLineSeparator(String separator) {
        this.defaultFormat.lineSeparator = separator;
    }

    public void setNewlines(boolean newlines) {
        this.defaultFormat.newlines = newlines;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
    }

    public void setOmitDeclaration(boolean omitDeclaration) {
        this.omitDeclaration = omitDeclaration;
    }

    public void setExpandEmptyElements(boolean expandEmptyElements) {
        this.defaultFormat.expandEmptyElements = expandEmptyElements;
    }

    public void setTrimAllWhite(boolean trimAllWhite) {
        this.defaultFormat.trimAllWhite = trimAllWhite;
    }

    public void setTextTrim(boolean textTrim) {
        this.defaultFormat.textTrim = textTrim;
    }

    public void setTextNormalize(boolean textNormalize) {
        this.defaultFormat.textNormalize = textNormalize;
    }

    public void setIndent(String indent) {
        if ("".equals(indent)) {
            indent = null;
        }
        this.defaultFormat.indent = indent;
    }

    public void output(Document doc, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doc, writer);
    }

    public void output(DocType doctype, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doctype, writer);
    }

    public void output(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(element, writer);
    }

    public void outputElementContent(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.outputElementContent(element, writer);
    }

    public void output(List list, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(list, writer);
    }

    public void output(CDATA cdata, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(cdata, writer);
    }

    public void output(Text text, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(text, writer);
    }

    public void output(Comment comment, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(comment, writer);
    }

    public void output(ProcessingInstruction pi, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(pi, writer);
    }

    public void output(EntityRef entity, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(entity, writer);
    }

    protected Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        return this.makeWriter(out, this.encoding);
    }

    protected Writer makeWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            enc = "UTF8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), enc));
        return writer;
    }

    public void output(Document doc, Writer out) throws IOException {
        this.printDeclaration(doc, out, this.encoding);
        if (doc.getDocType() != null) {
            this.printDocType(doc.getDocType(), out);
            out.write(this.currentFormat.lineSeparator);
        }
        List content = doc.getContent();
        int size = content.size();
        int i = 0;
        while (i < size) {
            Object obj = content.get(i);
            if (obj instanceof Element) {
                this.printElement(doc.getRootElement(), out, 0, this.createNamespaceStack());
            } else if (obj instanceof Comment) {
                this.printComment((Comment)obj, out);
            } else if (obj instanceof ProcessingInstruction) {
                this.printProcessingInstruction((ProcessingInstruction)obj, out);
            }
            this.newline(out);
            this.indent(out, 0);
            ++i;
        }
        out.write(this.currentFormat.lineSeparator);
        out.flush();
    }

    public void output(DocType doctype, Writer out) throws IOException {
        this.printDocType(doctype, out);
        out.flush();
    }

    public void output(Element element, Writer out) throws IOException {
        this.printElement(element, out, 0, this.createNamespaceStack());
        out.flush();
    }

    public void outputElementContent(Element element, Writer out) throws IOException {
        List content = element.getContent();
        this.printContentRange(content, 0, content.size(), out, 0, this.createNamespaceStack());
        out.flush();
    }

    public void output(List list, Writer out) throws IOException {
        this.printContentRange(list, 0, list.size(), out, 0, this.createNamespaceStack());
        out.flush();
    }

    public void output(CDATA cdata, Writer out) throws IOException {
        this.printCDATA(cdata, out);
        out.flush();
    }

    public void output(Text text, Writer out) throws IOException {
        this.printText(text, out);
        out.flush();
    }

    public void output(Comment comment, Writer out) throws IOException {
        this.printComment(comment, out);
        out.flush();
    }

    public void output(ProcessingInstruction pi, Writer out) throws IOException {
        this.printProcessingInstruction(pi, out);
        out.flush();
    }

    public void output(EntityRef entity, Writer out) throws IOException {
        this.printEntityRef(entity, out);
        out.flush();
    }

    public String outputString(Document doc) {
        StringWriter out = new StringWriter();
        try {
            this.output(doc, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(DocType doctype) {
        StringWriter out = new StringWriter();
        try {
            this.output(doctype, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(Element element) {
        StringWriter out = new StringWriter();
        try {
            this.output(element, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(List list) {
        StringWriter out = new StringWriter();
        try {
            this.output(list, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(CDATA cdata) {
        StringWriter out = new StringWriter();
        try {
            this.output(cdata, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(Text text) {
        StringWriter out = new StringWriter();
        try {
            this.output(text, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(Comment comment) {
        StringWriter out = new StringWriter();
        try {
            this.output(comment, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(ProcessingInstruction pi) {
        StringWriter out = new StringWriter();
        try {
            this.output(pi, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    public String outputString(EntityRef entity) {
        StringWriter out = new StringWriter();
        try {
            this.output(entity, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    protected void printDeclaration(Document doc, Writer out, String encoding) throws IOException {
        if (!this.omitDeclaration) {
            out.write("<?xml version=\"1.0\"");
            if (!this.omitEncoding) {
                out.write(" encoding=\"" + encoding + "\"");
            }
            out.write("?>");
            out.write(this.currentFormat.lineSeparator);
        }
    }

    protected void printDocType(DocType docType, Writer out) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        out.write("<!DOCTYPE ");
        out.write(docType.getElementName());
        if (publicID != null) {
            out.write(" PUBLIC \"");
            out.write(publicID);
            out.write("\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                out.write(" SYSTEM");
            }
            out.write(" \"");
            out.write(systemID);
            out.write("\"");
        }
        if (internalSubset != null && !internalSubset.equals("")) {
            out.write(" [");
            out.write(this.currentFormat.lineSeparator);
            out.write(docType.getInternalSubset());
            out.write("]");
        }
        out.write(">");
    }

    protected void printComment(Comment comment, Writer out) throws IOException {
        out.write("<!--");
        out.write(comment.getText());
        out.write("-->");
    }

    protected void printProcessingInstruction(ProcessingInstruction pi, Writer out) throws IOException {
        String target = pi.getTarget();
        String rawData = pi.getData();
        if (!"".equals(rawData)) {
            out.write("<?");
            out.write(target);
            out.write(" ");
            out.write(rawData);
            out.write("?>");
        } else {
            out.write("<?");
            out.write(target);
            out.write("?>");
        }
    }

    protected void printEntityRef(EntityRef entity, Writer out) throws IOException {
        out.write("&");
        out.write(entity.getName());
        out.write(";");
    }

    protected void printCDATA(CDATA cdata, Writer out) throws IOException {
        String str = this.currentFormat.textNormalize ? cdata.getTextNormalize() : (this.currentFormat.textTrim ? cdata.getText().trim() : cdata.getText());
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    protected void printText(Text text, Writer out) throws IOException {
        String str = this.currentFormat.textNormalize ? text.getTextNormalize() : (this.currentFormat.textTrim ? text.getText().trim() : text.getText());
        out.write(this.escapeElementEntities(str));
    }

    protected void printString(String str, Writer out) throws IOException {
        if (this.currentFormat.textNormalize) {
            str = Text.normalizeString(str);
        } else if (this.currentFormat.textTrim) {
            str = str.trim();
        }
        out.write(this.escapeElementEntities(str));
    }

    protected void printElement(Element element, Writer out, int level, NamespaceStack namespaces) throws IOException {
        int size;
        int start;
        List attributes = element.getAttributes();
        List content = element.getContent();
        String space = null;
        if (attributes != null) {
            space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
        }
        Format previousFormat = this.currentFormat;
        if ("default".equals(space)) {
            this.currentFormat = this.defaultFormat;
        } else if ("preserve".equals(space)) {
            this.currentFormat = this.noFormatting;
        }
        out.write("<");
        out.write(element.getQualifiedName());
        int previouslyDeclaredNamespaces = namespaces.size();
        this.printElementNamespace(element, out, namespaces);
        this.printAdditionalNamespaces(element, out, namespaces);
        if (attributes != null) {
            this.printAttributes(attributes, element, out, namespaces);
        }
        if ((start = this.skipLeadingWhite(content, 0)) >= (size = content.size())) {
            if (this.currentFormat.expandEmptyElements) {
                out.write("></");
                out.write(element.getQualifiedName());
                out.write(">");
            } else {
                out.write(" />");
            }
        } else {
            out.write(">");
            if (this.nextNonText(content, start) < size) {
                this.newline(out);
                this.printContentRange(content, start, size, out, level + 1, namespaces);
                this.newline(out);
                this.indent(out, level);
            } else {
                this.printTextRange(content, start, size, out);
            }
            out.write("</");
            out.write(element.getQualifiedName());
            out.write(">");
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
        this.currentFormat = previousFormat;
    }

    protected void printContentRange(List content, int start, int end, Writer out, int level, NamespaceStack namespaces) throws IOException {
        int index = start;
        while (index < end) {
            boolean firstNode = index == start;
            Object next = content.get(index);
            if (next instanceof Text) {
                int first = this.skipLeadingWhite(content, index);
                if (first >= (index = this.nextNonText(content, first))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(content, first, index, out);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next instanceof Comment) {
                this.printComment((Comment)next, out);
            } else if (next instanceof Element) {
                this.printElement((Element)next, out, level, namespaces);
            } else if (next instanceof EntityRef) {
                this.printEntityRef((EntityRef)next, out);
            } else if (next instanceof ProcessingInstruction) {
                this.printProcessingInstruction((ProcessingInstruction)next, out);
            }
            ++index;
        }
    }

    protected void printTextRange(List content, int start, int end, Writer out) throws IOException {
        int size;
        String previous = null;
        if ((start = this.skipLeadingWhite(content, start)) < (size = content.size())) {
            end = this.skipTrialingWhite(content, end);
            int i = start;
            while (i < end) {
                Object node = content.get(i);
                String next = ((Text)node).getText();
                if (next != null && !"".equals(next)) {
                    if (previous != null && (this.currentFormat.textNormalize || this.currentFormat.textTrim) && (this.endsWithWhite(previous) || this.startsWithWhite(next))) {
                        out.write(" ");
                    }
                    if (node instanceof CDATA) {
                        this.printCDATA((CDATA)node, out);
                    } else {
                        this.printString(next, out);
                    }
                    previous = next;
                }
                ++i;
            }
        }
    }

    private void printNamespace(Namespace ns, Writer out, NamespaceStack namespaces) throws IOException {
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        if (uri.equals(namespaces.getURI(prefix))) {
            return;
        }
        out.write(" xmlns");
        if (!prefix.equals("")) {
            out.write(":");
            out.write(prefix);
        }
        out.write("=\"");
        out.write(uri);
        out.write("\"");
        namespaces.push(ns);
    }

    protected void printAttributes(List attributes, Element parent, Writer out, NamespaceStack namespaces) throws IOException {
        int i = 0;
        while (i < attributes.size()) {
            Attribute attribute = (Attribute)attributes.get(i);
            Namespace ns = attribute.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                this.printNamespace(ns, out, namespaces);
            }
            out.write(" ");
            out.write(attribute.getQualifiedName());
            out.write("=");
            out.write("\"");
            out.write(this.escapeAttributeEntities(attribute.getValue()));
            out.write("\"");
            ++i;
        }
    }

    private void printElementNamespace(Element element, Writer out, NamespaceStack namespaces) throws IOException {
        Namespace ns = element.getNamespace();
        if (ns == Namespace.XML_NAMESPACE) {
            return;
        }
        if (ns != Namespace.NO_NAMESPACE || namespaces.getURI("") != null) {
            this.printNamespace(ns, out, namespaces);
        }
    }

    private void printAdditionalNamespaces(Element element, Writer out, NamespaceStack namespaces) throws IOException {
        List list = element.getAdditionalNamespaces();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                Namespace additional = (Namespace)list.get(i);
                this.printNamespace(additional, out, namespaces);
                ++i;
            }
        }
    }

    protected void newline(Writer out) throws IOException {
        if (this.currentFormat.newlines) {
            out.write(this.currentFormat.lineSeparator);
        }
    }

    protected void indent(Writer out, int level) throws IOException {
        if (this.currentFormat.newlines) {
            if (this.currentFormat.indent == null || this.currentFormat.indent.equals("")) {
                return;
            }
            int i = 0;
            while (i < level) {
                out.write(this.currentFormat.indent);
                ++i;
            }
        }
    }

    private int skipLeadingWhite(List content, int start) {
        if (start < 0) {
            start = 0;
        }
        int index = start;
        int size = content.size();
        if (this.currentFormat.trimAllWhite || this.currentFormat.textNormalize || this.currentFormat.textTrim) {
            while (index < size) {
                if (!this.isAllWhitespace(content.get(index))) {
                    return index;
                }
                ++index;
            }
        }
        return index;
    }

    private int skipTrialingWhite(List content, int start) {
        int size = content.size();
        if (start > size) {
            start = size;
        }
        int index = start;
        if (this.currentFormat.trimAllWhite || this.currentFormat.textNormalize || this.currentFormat.textTrim) {
            while (index >= 0) {
                if (!this.isAllWhitespace(content.get(index - 1))) break;
                --index;
            }
        }
        return index;
    }

    private int nextNonText(List content, int start) {
        if (start < 0) {
            start = 0;
        }
        int index = start;
        int size = content.size();
        while (index < size) {
            if (!(content.get(index) instanceof Text)) {
                return index;
            }
            ++index;
        }
        return size;
    }

    private boolean isAllWhitespace(Object obj) {
        String str = null;
        if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof Text) {
            str = ((Text)obj).getText();
        } else {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!this.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean startsWithWhite(String str) {
        return str != null && str.length() > 0 && this.isWhitespace(str.charAt(0));
    }

    private boolean endsWithWhite(String str) {
        return str != null && str.length() > 0 && this.isWhitespace(str.charAt(str.length() - 1));
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    public String escapeAttributeEntities(String str) {
        StringBuffer buffer = null;
        int i = 0;
        while (i < str.length()) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity != null) {
                    buffer = new StringBuffer(str.length() + 20);
                    buffer.append(str.substring(0, i));
                    buffer.append(entity);
                }
            } else if (entity == null) {
                buffer.append(ch);
            } else {
                buffer.append(entity);
            }
            ++i;
        }
        return buffer == null ? str : buffer.toString();
    }

    public String escapeElementEntities(String str) {
        StringBuffer buffer = null;
        int i = 0;
        while (i < str.length()) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity != null) {
                    buffer = new StringBuffer(str.length() + 20);
                    buffer.append(str.substring(0, i));
                    buffer.append(entity);
                }
            } else if (entity == null) {
                buffer.append(ch);
            } else {
                buffer.append(entity);
            }
            ++i;
        }
        return buffer == null ? str : buffer.toString();
    }

    public int parseArgs(String[] args, int i) {
        while (i < args.length) {
            if (args[i].equals("-omitDeclaration")) {
                this.setOmitDeclaration(true);
            } else if (args[i].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (args[i].equals("-indent")) {
                this.setIndent(args[++i]);
            } else if (args[i].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (args[i].equals("-encoding")) {
                this.setEncoding(args[++i]);
            } else if (args[i].equals("-newlines")) {
                this.setNewlines(true);
            } else if (args[i].equals("-lineSeparator")) {
                this.setLineSeparator(args[++i]);
            } else if (args[i].equals("-trimAllWhite")) {
                this.setTrimAllWhite(true);
            } else if (args[i].equals("-textTrim")) {
                this.setTextTrim(true);
            } else if (args[i].equals("-textNormalize")) {
                this.setTextNormalize(true);
            } else {
                return i;
            }
            ++i;
        }
        return i;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.defaultFormat.lineSeparator.length()) {
            char ch = this.defaultFormat.lineSeparator.charAt(i);
            switch (ch) {
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                default: {
                    buffer.append("[" + ch + "]");
                }
            }
            ++i;
        }
        return "XMLOutputter[omitDeclaration = " + this.omitDeclaration + ", " + "encoding = " + this.encoding + ", " + "omitEncoding = " + this.omitEncoding + ", " + "indent = '" + this.defaultFormat.indent + "'" + ", " + "expandEmptyElements = " + this.defaultFormat.expandEmptyElements + ", " + "newlines = " + this.defaultFormat.newlines + ", " + "lineSeparator = '" + buffer.toString() + "', " + "trimAllWhite = " + this.defaultFormat.trimAllWhite + "textTrim = " + this.defaultFormat.textTrim + "textNormalize = " + this.defaultFormat.textNormalize + "]";
    }

    protected NamespaceStack createNamespaceStack() {
        return new NamespaceStack();
    }

    public void output(String string, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(string, writer);
    }

    public void output(String string, Writer out) throws IOException {
        this.printString(string, out);
        out.flush();
    }

    public void setIndent(boolean doIndent) {
        this.defaultFormat.indent = doIndent ? STANDARD_INDENT : null;
    }

    public void setIndent(int size) {
        this.setIndentSize(size);
    }

    public void setIndentSize(int indentSize) {
        StringBuffer indentBuffer = new StringBuffer();
        int i = 0;
        while (i < indentSize) {
            indentBuffer.append(" ");
            ++i;
        }
        this.defaultFormat.indent = indentBuffer.toString();
    }

    public String outputString(String str) {
        StringWriter out = new StringWriter();
        try {
            this.output(str, (Writer)out);
        }
        catch (IOException e) {}
        return out.toString();
    }

    protected class NamespaceStack
    extends org.jdom.output.NamespaceStack {
        protected NamespaceStack() {
        }
    }

    class Format
    implements Cloneable {
        String indent = null;
        boolean expandEmptyElements = false;
        String lineSeparator = "\r\n";
        boolean trimAllWhite = false;
        boolean textTrim = false;
        boolean textNormalize = false;
        boolean newlines = false;

        Format() {
        }

        protected Object clone() {
            Format format = null;
            try {
                format = (Format)super.clone();
            }
            catch (CloneNotSupportedException ce) {}
            return format;
        }
    }
}

