/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.SearchSpace;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;
import freak.module.searchspace.logictree.AndNode;
import freak.module.searchspace.logictree.StaticCompareNode;

public class MonomMerge
extends MultiPairwiseCrossover
implements CompatibleWithDifferentSearchSpaces {
    public MonomMerge(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof BooleanFunction)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        StaticCompareNode cn;
        BooleanFunctionGenotype bf1_alt = (BooleanFunctionGenotype)ind1.getGenotype();
        BooleanFunctionGenotype bf2_alt = (BooleanFunctionGenotype)ind2.getGenotype();
        BooleanFunctionGenotype bf1 = (BooleanFunctionGenotype)bf1_alt.clone();
        BooleanFunctionGenotype bf2 = (BooleanFunctionGenotype)bf2_alt.clone();
        AndNode an1 = bf1.getUsedAndNodeRandomly();
        AndNode an2 = bf2.getUsedAndNodeRandomly();
        while (an2.getSubtreeSize() > 1) {
            cn = an2.getRandomChildComp();
            bf2.deleteCompare(an2, cn);
            bf1.insertCompare(an1, cn);
        }
        cn = an2.getRandomChildComp();
        bf1.insertCompare(an1, cn);
        return new Individual(this.graph.getSchedule(), bf1, new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "Gets Monoms from two Individuals and merges them. The old monoms are deleted and the new monom is put into the left individual";
    }

    public String getName() {
        return "MonomMerge";
    }
}

