% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_report}
\alias{get_report}
\title{Get Anaytics data for a view (profile)}
\usage{
get_report(type = c("ga", "mcf", "rt"), query, token,
  verbose = getOption("rga.verbose", FALSE))
}
\arguments{
\item{type}{character. Report type.}

\item{query}{\code{GAQuery} class object including a request parameters.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame with Google Analytics reporting data. Columns are metrics and dimesnions.
}
\description{
\code{get_report} provide a query the Core or Multi-Channel Funnels Reporting API for Google Analytics report data.
}
\examples{
\dontrun{
# get token data
authorize(client.id = "myID", client.secret = "mySecret")
# set query
ga_query <- set_query("myProfileID", start.date = "30daysAgo", end.date = "today",
                      metrics = "ga:sessions", dimensions = "ga:source,ga:medium"
                      sort = "-ga:sessions")
# get report data
ga_data <- get_report(ga_query, type = "ga")
}
}
\seealso{
\code{\link{authorize}} \code{\link{set_query}}

Other The.Google.Analytics.Reporting.API: \code{\link{get_firstdate}};
  \code{\link{get_ga}}; \code{\link{get_mcf}};
  \code{\link{get_rt}}
}
\keyword{internal}

