% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsMosaic.R
\name{lsMosaic}
\alias{lsMosaic}
\title{Mosaic a set of Landsat-7 or Landsat-8 images}
\usage{
lsMosaic(src, AppRoot, extent = NULL, out.name = "outfile",
  verbose = FALSE, gutils = FALSE, overwrite = FALSE, ...)
}
\arguments{
\item{src}{the path to the folder with the Landsat-7 or Landsa-8 images in
GTiff format.}

\item{AppRoot}{the directory to save the mosaicked images.}

\item{extent}{an \code{axtent}, \code{Raster*}, or \code{Spatial*} object
representing the region of interest.}

\item{out.name}{the name of the folder that stores the outputs. By default,
“outfile” is assigned.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{gutils}{logical argument. If \code{TRUE}, the function uses `GDAL'
utilities for mosaicking.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{...}{arguments for nested functions:
 \itemize{
  \item \code{pathrow} a list of vectors with the path and row numbers of
  the tiles concerning the region of interest.
  \item \code{bFilter} a vector with the bands to be mosaicked. If not
  supplied, all bands are mosaicked.
  \item \code{dayFilter} a vector with the capturing dates being considered
  for mosaicking. If not supplied, all dates are mosaicked.
}}
}
\description{
\code{lsMosaic} merges the Landsat-7 or Landsat-8 imagery that covers a 
region of interest on the same dates.
}
\details{
The function mosaics the imagery in the \code{src} folder. The folder can
hold GTiff images from several tiles, dates and bands. When only a subset
of bands or dates has to be mosaicked, the band names or dates should be
provided through the argument \code{bFilter} or \code{dateFilter}. Band
names are defined by the letter “b” and the two-digit band number
(e.g., ‘b01’). The dates must be provided as a \code{Date} class object.
Once mosaicked, the images can be cropped to fit the extent (optional).
The extent can be defined in any coordinate reference system, since
\code{lsMosaic} automatically reprojects the extent to match the projection
of the image. The outputs are placed in the \code{AppRoot} directory, under
the folder named as \code{out.name}. If no name is provided, the folder is
named “outfile”. To use `\code{gutils = TRUE}', a proper installation of `GDAL'
and the `\code{gdalUtils}' library is required. This method is faster than
native `R' functions.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
# download Landsat-8 images
lsDownload(satellite = "ls8",
           username = "username",
           password = "password",
           startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
           endDate = as.Date("20-01-2018", "\%d-\%m-\%Y"),
           extent = ex.navarre,
           untar = TRUE,
           AppRoot = src)
# folder with the Landsat-8 untared images
ls8.src <- file.path(src, "Landsat8")
tif.src <- file.path(ls8.src,"untar")
# mosaic the Landsat-8 images
lsMosaic(src = tif.src,
         AppRoot = ls8.src,
         out.name = "Navarre")

lsMosaic(src = tif.src,
         AppRoot = ls8.src,
         out.name = "Navarre",
         extent = ex.navarre,
         gutils = TRUE, # using gdalUtils
         overwrite = TRUE) # overwrite
}
}
