% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varRGB.R
\name{varRGB}
\alias{varRGB}
\title{Generate an RGB image from 3 spectral bands}
\usage{
varRGB(red, green, blue, q.range = c(), rPath = NULL, region = NULL)
}
\arguments{
\item{red}{a \code{raster} with the red band of the capture.}

\item{green}{a \code{raster} with the green band of the capture.}

\item{blue}{a \code{raster} with the blue band of the capture.}

\item{q.range}{a vector with the minimum and maximum reflectance quantiles
being considered.}

\item{rPath}{the file path where the resulting RGB image is saved.}

\item{region}{a \code{Spatial*}, projected \code{raster*}, or \code{sf} class object 
defining the area of interest for image masking.}
}
\description{
\code{varRGB} creates red-green-blue (RGB) images as a \code{RasterStack} by
scaling the pixel values to 0-255 color range.
}
\details{
The function rescales the original reflectance values to a range of 0-255.
The function re-arranges the RGB bands to create a stack ready to visualize
with plotRGB. Bands may contain outliers which cause the image to look dark.
Use the \code{q.range} argument to remove the outliers and get a 
better-looking image.
}
\examples{
# path to the cropped and cutted MODIS images for the region of Navarre
wdir <- system.file("ExNavarreVar", package = "RGISTools")
# list all the tif files
files.mod <- list.files(wdir, pattern="\\\\.tif$", recursive = TRUE, full.names = TRUE)
# print the MOD09 bands
getRGISToolsOpt("MOD09BANDS")

# select the red, blue and NIR bands
img.mod.red <- raster(files.mod[1])
img.mod.blue <- raster(files.mod[3])
img.mod.green <- raster(files.mod[4])

q.range=c(0.001,0.999)
img.mod.rgb<-varRGB(img.mod.red,img.mod.green,img.mod.blue,q.range)
print(plotRGB(img.mod.rgb))
}
