/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.util.Resources;

public abstract class Tool {
    protected PrintStream out = System.out;
    private Properties resources;

    public void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    public abstract void run(String ... var1) throws SQLException;

    protected SQLException throwUnsupportedOption(String string) throws SQLException {
        this.showUsage();
        throw new SQLException("Unsupported option: " + string);
    }

    protected void printNoDatabaseFilesFound(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("No database files have been found");
        if (string != null) {
            stringBuilder.append(" in directory ").append(string);
        }
        if (string2 != null) {
            stringBuilder.append(" for the database ").append(string2);
        }
        this.out.println(stringBuilder.toString());
    }

    protected void showUsage() {
        String string;
        if (this.resources == null) {
            this.resources = new Properties();
            string = "/org/h2/res/javadoc.properties";
            try {
                byte[] byArray = Resources.get(string);
                if (byArray != null) {
                    this.resources.load(new ByteArrayInputStream(byArray));
                }
            }
            catch (IOException iOException) {
                this.out.println("Cannot load " + string);
            }
        }
        string = this.getClass().getName();
        this.out.println(this.resources.get(string));
        this.out.println("Usage: java " + this.getClass().getName() + " <options>");
        this.out.println(this.resources.get(string + ".main"));
        this.out.println("See also http://h2database.com/javadoc/" + string.replace('.', '/') + ".html");
    }

    public static int readArgBoolean(String[] stringArray, int n) {
        if (!SysProperties.OLD_COMMAND_LINE_OPTIONS) {
            return 0;
        }
        if (n + 1 < stringArray.length) {
            String string;
            if ("true".equals(string = stringArray[++n])) {
                return 1;
            }
            if ("false".equals(string)) {
                return -1;
            }
        }
        return 0;
    }
}

