% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poincarePlot.R
\name{PoincarePlot}
\alias{PoincarePlot}
\title{Poincare Plot}
\usage{
PoincarePlot(HRVData,
  indexNonLinearAnalysis = length(HRVData$NonLinearAnalysis), timeLag = 1,
  confidenceEstimation = FALSE, confidence = 0.95, doPlot = FALSE,
  main = "Poincare plot", xlab = "RR[n]", ylab = paste0("RR[n+", timeLag,
  "]"), pch = 1, cex = 0.3, type = "p", xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information related to it}

\item{indexNonLinearAnalysis}{Reference to the data structure that will contain the nonlinear analysis}

\item{timeLag}{Integer denoting the number of time steps that will be use to construct the 
dependance relation:  \eqn{RR_{j+timeLag}}{RR_(j+timeLag)} as a function of \eqn{RR_j}.}

\item{confidenceEstimation}{Logical value. If TRUE, the covariance matrix is
used for fitting the ellipse and computing the \eqn{SD_1} and
\eqn{SD_2} parameters (see details). Default: FALSE.}

\item{confidence}{The confidence used for plotting the confidence ellipse.}

\item{doPlot}{Logical value. If TRUE (default), the PoincarePlot is shown.}

\item{main}{An overall title for the Poincare plot.}

\item{xlab}{A title for the x axis.}

\item{ylab}{A title for the y axis.}

\item{pch}{Plotting character (symbol to use).}

\item{cex}{Character (or symbol) expansion.}

\item{type}{What type of plot should be drawn. See \code{\link[graphics]{plot.default}}.}

\item{xlim}{x coordinates range. If not specified, a proper x range is selected.}

\item{ylim}{y coordinates range. If not specified, a proper y range is selected.}

\item{...}{Additional parameters for the Poincare plot figure.}
}
\value{
A \emph{HRVData} structure containing a \emph{PoincarePlot} field storing
the \eqn{SD_1} and \eqn{SD_2} parameters. The \emph{PoincarePlot} field is
stored under the \emph{NonLinearAnalysis} list.
}
\description{
The Poincare plot is a graphical representation of the dependance
 between successive RR intervals obtained by plotting the \eqn{RR_{j+\tau}}{RR_(j+tau)}
 as a function of \eqn{RR_j}. This dependance is often quantified by fitting an
 ellipse to the plot. In this way, two parameters are obtained:  
\eqn{SD_1}  and \eqn{SD_2}.
\eqn{SD_1} characterizes short-term variability
whereas that \eqn{SD_2} characterizes long-term variability.
}
\details{
In the HRV literature, when \emph{timeLag = 1}, the \eqn{SD_1} and \eqn{SD_2}
parameters are computed using time domain measures. This is the default approach in this
function if \emph{timeLag=1}. This function also allows the user to fit a ellipse
 by computing the covariance matrix of 
 (\eqn{RR_{j}}{RR_(j)},\eqn{RR_{j+\tau}}{RR_(j+tau)})
(by setting \emph{confidenceEstimation = TRUE}). In most cases, both approaches
yield similar results.
}
\examples{
\dontrun{
 data(HRVProcessedData)
 # rename for convenience
 hd = HRVProcessedData
 hd = CreateNonLinearAnalysis(hd)
 hd = PoincarePlot(hd, doPlot = T)
}
}

