/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HftpFileSystem;

public class HsftpFileSystem
extends HftpFileSystem {
    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        HsftpFileSystem.setupSsl(conf);
    }

    private static void setupSsl(Configuration conf) {
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("dfs.https.client.keystore.resource", "ssl-client.xml"));
        System.setProperty("javax.net.ssl.trustStore", sslConf.get("ssl.client.truststore.location", ""));
        System.setProperty("javax.net.ssl.trustStorePassword", sslConf.get("ssl.client.truststore.password", ""));
        System.setProperty("javax.net.ssl.trustStoreType", sslConf.get("ssl.client.truststore.type", "jks"));
        System.setProperty("javax.net.ssl.keyStore", sslConf.get("ssl.client.keystore.location", ""));
        System.setProperty("javax.net.ssl.keyStorePassword", sslConf.get("ssl.client.keystore.password", ""));
        System.setProperty("javax.net.ssl.keyPassword", sslConf.get("ssl.client.keystore.keypassword", ""));
        System.setProperty("javax.net.ssl.keyStoreType", sslConf.get("ssl.client.keystore.type", "jks"));
    }

    @Override
    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        try {
            query = this.updateQuery(query);
            URL url = new URI("https", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), path, query, null).toURL();
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setHostnameVerifier(new DummyHostnameVerifier());
            return conn;
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public URI getUri() {
        try {
            return new URI("hsftp", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected static class DummyHostnameVerifier
    implements HostnameVerifier {
        protected DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

