% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateResults.R
\name{getSubsetForDefinedCats}
\alias{getSubsetForDefinedCats}
\title{Function to group the data according to a specified feature.}
\usage{
getSubsetForDefinedCats(
  subsetDef,
  distType = FALSE,
  tableTCs,
  errorList,
  catList = NULL,
  catLabels = NULL,
  restrict = NULL
)
}
\arguments{
\item{subsetDef}{(character) listing either the analytes or distribution types for which the result files should be parsed}

\item{distType}{(logical) indicating if 'subsetDef' refers to analytes (FALSE, default) or distribution types (TRUE)}

\item{tableTCs}{(data.frame) containing all information about the simulated test sets}

\item{errorList}{(list) containing the table with the computed error measurements}

\item{catList}{(list) containing the categories to split the dataset}

\item{catLabels}{(list) containing the labels that will be used for the categories}

\item{restrict}{(character) indicating whether testcases should be filtered according to specified restriction, default NULL, 
e.g. fractionPathol <= 0.30}
}
\value{
(list) containing the performance measurements grouped according to specified subset definition and categories
}
\description{
Function to group the data according to a specified feature.
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
