/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import java.util.List;

public class ProcDiagnostic {
    public final double value;
    public final ProcQuality quality;
    public static final String QUALITY = "quality";

    public ProcDiagnostic(double value, ProcQuality quality) {
        this.value = value;
        this.quality = quality;
    }

    public static ProcQuality summary(InformationSet summary) {
        ProcQuality rslt = ProcQuality.Undefined;
        int sum = 0;
        int n = 0;
        ProcQuality q = summary.get(QUALITY, ProcQuality.class);
        if (q != null) {
            return q;
        }
        List<Information<InformationSet>> subsets = summary.select(InformationSet.class);
        for (Information<InformationSet> subset : subsets) {
            List<Information<ProcDiagnostic>> infos = ((InformationSet)subset.value).select(ProcDiagnostic.class);
            for (Information<ProcDiagnostic> info : infos) {
                ProcQuality quality = ((ProcDiagnostic)info.value).quality;
                switch (quality) {
                    case Error: {
                        summary.set(QUALITY, ProcQuality.Error);
                        return ProcQuality.Error;
                    }
                    case Severe: {
                        summary.set(QUALITY, ProcQuality.Severe);
                        return ProcQuality.Severe;
                    }
                    case Good: {
                        ++n;
                        sum += 3;
                        break;
                    }
                    case Uncertain: {
                        ++n;
                        sum += 2;
                        break;
                    }
                    case Bad: {
                        ++n;
                    }
                }
            }
        }
        if (n > 0) {
            double val = sum;
            rslt = (val /= (double)n) >= 2.5 ? ProcQuality.Good : (val >= 1.5 ? ProcQuality.Uncertain : ProcQuality.Bad);
        }
        summary.set(QUALITY, rslt);
        return rslt;
    }
}

