/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.DefaultTrendFilteringStrategy;
import ec.satoolkit.x11.SeriesEvolution;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Context;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class ICRatioComputer {
    public static void writeICR(X11Context context, TsData s, InformationSet info) {
        int freq = context.getFrequency();
        int filterLength = freq + 1;
        if (freq == 2) {
            filterLength = 5;
        }
        SymmetricFilter trendFilter = TrendCycleFilterFactory.makeHendersonFilter(filterLength);
        DefaultTrendFilteringStrategy strategy = new DefaultTrendFilteringStrategy(trendFilter, null, filterLength + " terms Henderson moving average");
        TsData sc = strategy.process(s, s.getDomain());
        TsData si = context.op(s, sc);
        int nf = context.getForecastHorizon();
        int nb = context.getBackcastHorizon();
        TsDomain gdom = nf == 0 && nb == 0 ? null : sc.getDomain().drop(nb, nf);
        InformationSet dtables = info.subSet("d-tables");
        double gc = SeriesEvolution.calcAbsMeanVariations(sc, gdom, 1, context.isMultiplicative() || context.isPseudoAdditive(), null);
        double gi = SeriesEvolution.calcAbsMeanVariations(si, gdom, 1, context.isMultiplicative() || context.isPseudoAdditive(), null);
        double icr = gi / gc;
        if (freq == 4) {
            icr *= 3.0;
        } else if (freq == 2) {
            icr *= 6.0;
        }
        dtables.set("d12-IC ratio", Double.valueOf(icr));
    }
}

