/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.IDistribution;
import ec.tstoolkit.dstats.ProbabilityType;

public interface IContinuousDistribution
extends IDistribution {
    public double getDensity(double var1) throws DStatException;

    public double getLeftBound();

    default public double getProbabilityForInterval(double x, double y) throws DStatException {
        double u;
        double l;
        if (Double.isFinite(x) && Double.isFinite(y) && x > y) {
            l = y;
            u = x;
        } else {
            l = x;
            u = y;
        }
        double pu = Double.isFinite(u) ? this.getProbability(u, ProbabilityType.Lower) : 1.0;
        double pl = Double.isFinite(l) ? this.getProbability(l, ProbabilityType.Lower) : 0.0;
        return pu > pl ? pu - pl : 0.0;
    }

    public double getRightBound();
}

