/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IRegressionTest;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.SeparateRegressionTest;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import java.util.List;

public class RegressionVariablesTest2
extends AbstractTramoModule
implements IPreprocessingModule {
    private final IRegressionTest tdTest_;
    private final IRegressionTest wdTest_;
    private final IRegressionTest lpTest_;
    private final IRegressionTest mhTest_;
    private final IRegressionTest meanTest_;

    public RegressionVariablesTest2(double cval, double mval) {
        this.tdTest_ = new SeparateRegressionTest(cval, cval);
        this.wdTest_ = new SeparateRegressionTest(cval);
        this.lpTest_ = new SeparateRegressionTest(cval);
        this.mhTest_ = new SeparateRegressionTest(cval);
        this.meanTest_ = new SeparateRegressionTest(mval);
    }

    private void addInfo(ModelDescription desc, InformationSet information) {
        InformationSet subset = information.subSet("calendar");
        subset.set("count", Integer.valueOf(desc.countRegressors(var -> var.status.isSelected() && var.isCompatible(ICalendarVariable.class))));
        InformationSet esubset = information.subSet("easter");
        esubset.set("easter", Integer.valueOf(desc.countRegressors(var -> var.status.isSelected() && var.isCompatible(IMovingHolidayVariable.class))));
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        Variable search;
        int i;
        boolean changed = false;
        int nhp = context.description.getArimaComponent().getFreeParametersCount();
        ConcentratedLikelihood ll = context.estimation.getLikelihood();
        InformationSet tdsubset = context.information.subSet("calendar");
        InformationSet esubset = context.information.subSet("easter");
        TsVariableList x = context.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> tdsel = x.selectCompatible(ITradingDaysVariable.class);
        TsVariableSelection<ITsVariable> lpsel = x.selectCompatible(ILengthOfPeriodVariable.class);
        boolean usetd = false;
        TsVariableSelection.Item<ITsVariable>[] items = tdsel.elements();
        int start = context.description.getRegressionVariablesStartingPosition();
        for (i = 0; i < items.length; ++i) {
            IRegressionTest test;
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            IRegressionTest iRegressionTest = test = items[i].variable.getDim() == 1 ? this.wdTest_ : this.tdTest_;
            if (!test.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), tdsubset)) continue;
            usetd = true;
        }
        if (!usetd) {
            items = lpsel.elements();
            for (i = 0; i < items.length; ++i) {
                search = context.description.searchVariable((ITsVariable)items[i].variable);
                if (!search.status.needTesting() || !this.lpTest_.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), tdsubset)) continue;
                usetd = true;
            }
        }
        items = tdsel.elements();
        for (i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            if (usetd) {
                search.status = RegStatus.Accepted;
                continue;
            }
            search.status = RegStatus.Rejected;
            changed = true;
        }
        items = lpsel.elements();
        for (i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            if (usetd) {
                search.status = RegStatus.Accepted;
                continue;
            }
            search.status = RegStatus.Rejected;
            changed = true;
        }
        TsVariableSelection<ITsVariable> mhsel = x.selectCompatible(IMovingHolidayVariable.class);
        items = mhsel.elements();
        for (int i2 = 0; i2 < items.length; ++i2) {
            Variable search2 = context.description.searchVariable((ITsVariable)items[i2].variable);
            if (!search2.status.needTesting()) continue;
            if (this.mhTest_.accept(ll, nhp, start + items[i2].position, items[i2].variable.getDim(), esubset)) {
                search2.status = RegStatus.Accepted;
                continue;
            }
            search2.status = RegStatus.Rejected;
            changed = true;
        }
        if (!this.testUsers(x, context.description.getCalendars(), start, ll, nhp)) {
            changed = true;
        }
        if (!this.testUsers(x, context.description.getMovingHolidays(), start, ll, nhp)) {
            changed = true;
        }
        if (!this.testUsers(x, context.description.getUserVariables(), start, ll, nhp)) {
            changed = true;
        }
        if (context.automodelling && context.description.isEstimatedMean() && !this.meanTest_.accept(ll, nhp, 0, 1, esubset)) {
            context.description.setMean(false);
            changed = true;
        }
        this.addInfo(context.description, context.information);
        if (changed) {
            context.estimation = null;
        }
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }

    private boolean testUsers(TsVariableList x, List<Variable> vars, int start, ConcentratedLikelihood ll, int nhp) {
        TsVariableSelection<ITsVariable> sel = x.select(var -> var instanceof IUserTsVariable && Variable.search(vars, var) != null);
        if (sel.isEmpty()) {
            return true;
        }
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        boolean changed = false;
        for (int i = 0; i < items.length; ++i) {
            IRegressionTest test;
            Variable search = Variable.search(vars, items[i].variable);
            if (search == null || !search.status.needTesting()) continue;
            IRegressionTest iRegressionTest = test = items[i].variable.getDim() == 1 ? this.wdTest_ : this.tdTest_;
            if (test.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), null)) {
                search.status = RegStatus.Accepted;
                continue;
            }
            search.status = RegStatus.Rejected;
            changed = true;
        }
        return changed;
    }
}

