/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.implementation;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public abstract class AbstractHeteroskedasticSsf
implements ISsf {
    private final ISsf ssf;
    private final int sdim;

    public AbstractHeteroskedasticSsf(ISsf ssf) {
        this.ssf = ssf;
        this.sdim = ssf.getStateDim();
    }

    protected abstract double h(int var1);

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Z(int pos, DataBlock x) {
        this.ssf.Z(pos, this.sub(x));
        double ht = this.h(pos);
        if (ht != 0.0) {
            x.mul(this.sdim, ht);
        } else {
            x.set(this.sdim, 0.0);
        }
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        this.ssf.ZM(pos, this.rsub(m), x);
        double ht = this.h(pos);
        if (ht != 0.0) {
            x.addAY(ht, m.row(this.sdim));
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double z = this.ssf.ZVZ(pos, this.sub(vm));
        double ht = this.h(pos);
        if (ht != 0.0) {
            z += 2.0 * ht * this.ssf.ZX(pos, vm.column(this.sdim).drop(0, 1));
            z += ht * ht * vm.get(this.sdim, this.sdim);
        }
        return z;
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        double z = this.ssf.ZX(pos, this.sub(x));
        double ht = this.h(pos);
        if (ht != 0.0) {
            z += ht * x.get(this.sdim);
        }
        return z;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.ssf.diffuseConstraints(this.rsub(b));
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.ssf.fullQ(pos, this.sub(qm));
        qm.set(this.sdim, this.sdim, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return this.ssf.getNonStationaryDim();
    }

    @Override
    public int getStateDim() {
        return this.ssf.getStateDim() + 1;
    }

    @Override
    public int getTransitionResCount() {
        return this.ssf.getTransitionResCount() + 1;
    }

    @Override
    public int getTransitionResDim() {
        return this.ssf.getTransitionResDim() + 1;
    }

    @Override
    public boolean hasR() {
        return this.ssf.hasR();
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return this.ssf.hasTransitionRes(pos) || this.h(pos) != 0.0;
    }

    @Override
    public boolean hasW() {
        return this.ssf.hasW();
    }

    @Override
    public boolean isDiffuse() {
        return this.ssf.isDiffuse();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return this.ssf.isTransitionEquationTimeInvariant();
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return this.ssf.isTransitionResidualTimeInvariant();
    }

    @Override
    public boolean isValid() {
        return this.ssf.isValid();
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.ssf.Pf0(this.sub(pf0));
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.ssf.Pf0(this.sub(pi0));
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        int r = qm.getColumnsCount() - 1;
        this.ssf.Q(pos, qm.extract(0, r, 0, r));
        qm.set(r, r, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        this.ssf.R(pos, rv.range(0, this.sdim));
        rv.set(rv.getLength() - 1, this.sdim);
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.ssf.T(pos, this.sub(tr));
        tr.column(this.sdim).set(0.0);
        tr.row(this.sdim).set(0.0);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        this.ssf.TVT(pos, this.sub(vm));
        vm.column(this.sdim).set(0.0);
        vm.row(this.sdim).set(0.0);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.ssf.TX(pos, this.sub(x));
        x.set(this.sdim, 0.0);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        int row = wv.getRowsCount() - 1;
        int col = wv.getColumnsCount() - 1;
        this.ssf.W(pos, wv.extract(0, row, 0, col));
        wv.column(col).set(0.0);
        wv.set(row, col, 1.0);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        this.ssf.XT(pos, this.sub(x));
        x.set(this.sdim, 0.0);
    }

    private SubMatrix sub(SubMatrix m) {
        return m.extract(0, this.sdim, 0, this.sdim);
    }

    private SubMatrix rsub(SubMatrix m) {
        return m.extract(0, this.sdim, 0, m.getColumnsCount());
    }

    private SubMatrix csub(SubMatrix m) {
        return m.extract(0, m.getRowsCount(), 0, this.sdim);
    }

    private DataBlock sub(DataBlock x) {
        return x.range(0, this.sdim);
    }
}

