/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.FiniteFilter;
import ec.tstoolkit.maths.linearfilters.ILinearProcess;

public class LinearProcessFiniteProperties {
    private int m_n = 49;
    private ILinearProcess m_lp;
    private FiniteFilter[] m_ff;

    public LinearProcessFiniteProperties() {
    }

    public LinearProcessFiniteProperties(ILinearProcess lp) {
        this.m_lp = lp;
    }

    private void calc() {
        if (this.m_lp == null || this.m_ff != null) {
            return;
        }
        this.m_ff = new FiniteFilter[this.m_n];
        int nc = this.m_lp.getOutputLength(this.m_n);
        for (int i = 0; i < this.m_n; ++i) {
            DataBlock data = new DataBlock(this.m_n);
            data.set(i, 1.0);
            DataBlock datac = new DataBlock(nc);
            this.m_lp.transform(data, datac);
            this.m_ff[i] = new FiniteFilter(datac.getData(), -i);
        }
    }

    private void clear() {
        this.m_ff = null;
    }

    public FiniteFilter finiteFilter(int idx) {
        this.calc();
        return this.m_ff[idx];
    }

    public int getDataLength() {
        return this.m_n;
    }

    public ILinearProcess getLinearProcess() {
        return this.m_lp;
    }

    public void setDataLength(int value) {
        if (this.m_n != value) {
            this.m_n = value;
            this.clear();
        }
    }

    public void setLinearProcess(ILinearProcess value) {
        this.m_lp = value;
        this.clear();
    }
}

