/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.AsymmetricEndPoints;
import ec.satoolkit.x11.BiasCorrection;
import ec.satoolkit.x11.DefaultNormalizingStrategie;
import ec.satoolkit.x11.DefaultTrendFilteringStrategy;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.IX11Utilities;
import ec.satoolkit.x11.MusgraveFilterFactory;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Exception;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.TsData;

public class DefaultX11Utilities
extends DefaultX11Algorithm
implements IX11Utilities {
    private double eps = 1.0E-9;

    @Override
    public boolean checkPositivity(TsData s) {
        double[] stc = s.internalStorage();
        int n = s.getLength();
        boolean changed = false;
        for (int i = 0; i < n; ++i) {
            int after;
            int before;
            if (!(stc[i] <= 0.0)) continue;
            changed = true;
            for (before = i - 1; before >= 0 && stc[before] <= 0.0; --before) {
            }
            for (after = i + 1; after < n && stc[after] <= 0.0; ++after) {
            }
            if (before < 0 && after >= n) {
                throw new X11Exception("Negative series");
            }
            double m = before >= 0 && after < n ? (stc[before] + stc[after]) / 2.0 : (after >= n ? stc[before] : stc[after]);
            stc[i] = m;
        }
        return changed;
    }

    @Override
    public TsData correctSeries(TsData sorig, TsData sweights, double dalternative) {
        TsData ns = sorig.clone();
        for (int i = 0; i < ns.getLength(); ++i) {
            double x = sweights.get(i);
            if (x != 0.0) continue;
            ns.set(i, dalternative);
        }
        return ns;
    }

    @Override
    public TsData correctSeries(TsData sorig, TsData sweights, TsData salternative) {
        TsData ns = sorig.clone();
        for (int i = 0; i < ns.getLength(); ++i) {
            double x = sweights.get(i);
            if (x != 0.0) continue;
            ns.set(i, salternative.get(i));
        }
        return ns;
    }

    @Override
    public TsData correctTrendBias(TsData t, TsData s, TsData i, BiasCorrection bias) {
        switch (bias) {
            case Legacy: {
                return this.legacyBiasCorrection(t, s, i);
            }
            case Ratio: {
                return this.ratioBiasCorrection(t, s, i);
            }
            case Smooth: {
                return this.smoothBiasCorrection(t, s, i);
            }
        }
        return t;
    }

    private TsData legacyBiasCorrection(TsData t, TsData s, TsData i) {
        double issq = i.log().ssq();
        double sig = Math.exp(issq / (double)(2 * i.getLength()));
        int ifreq = t.getFrequency().intValue();
        int length = 2 * ifreq - 1;
        SymmetricFilter smoother = TrendCycleFilterFactory.makeHendersonFilter(length);
        DefaultTrendFilteringStrategy filter = new DefaultTrendFilteringStrategy(smoother, new AsymmetricEndPoints(MusgraveFilterFactory.makeFilters(smoother, 4.5)));
        TsData hs = filter.process(s, null);
        hs.applyOnFinite(x -> x * sig);
        return t.times(hs);
    }

    private TsData smoothBiasCorrection(TsData t, TsData s, TsData i) {
        double issq = i.log().ssq();
        double sig = Math.exp(issq / (double)(2 * i.getLength()));
        int ifreq = t.getFrequency().intValue();
        TsData hs = new DefaultNormalizingStrategie().process(s, null, ifreq);
        hs.applyOnFinite(x -> x * sig);
        return t.times(hs);
    }

    private TsData ratioBiasCorrection(TsData t, TsData s, TsData i) {
        double sbias = s.fullYears().average();
        double ibias = i.average();
        s.apply(x -> x / sbias);
        return t.times(sbias * ibias);
    }

    @Override
    public TsData differences(TsData l, TsData r) {
        TsData o = new TsData(l.getDomain());
        int n = o.getLength();
        for (int i = 0; i < n; ++i) {
            double xr;
            double xl = l.get(i);
            if (!(Math.abs(xl - (xr = r.get(i))) > this.eps)) continue;
            o.set(i, xl);
        }
        return o;
    }

    public double getEpsilon() {
        return this.eps;
    }

    public void setEpsilon(double eps) {
        this.eps = eps;
    }
}

