/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.modelling.arima.DefaultArimaSpec;
import ec.tstoolkit.modelling.arima.x13.X13Exception;

public class ArimaSpec
extends DefaultArimaSpec {
    public static final int MAXP = 6;
    public static final int MAXD = 2;
    public static final int MAXQ = 6;
    public static final int MAXBP = 1;
    public static final int MAXBD = 1;
    public static final int MAXBQ = 1;

    public ArimaSpec() {
        this.airline();
    }

    @Override
    public ArimaSpec clone() {
        return (ArimaSpec)super.clone();
    }

    @Override
    public void setP(int value) {
        if (value > 6) {
            throw new X13Exception("P must be <= " + Integer.toString(6));
        }
        super.setP(value);
    }

    @Override
    public void setD(int value) {
        if (value > 2) {
            throw new X13Exception("D must be <= " + Integer.toString(2));
        }
        super.setD(value);
    }

    @Override
    public void setQ(int value) {
        if (value > 6) {
            throw new X13Exception("Q must be <= " + Integer.toString(6));
        }
        super.setQ(value);
    }

    @Override
    public void setBP(int value) {
        if (value > 1) {
            throw new X13Exception("BP must be <= " + Integer.toString(1));
        }
        super.setBP(value);
    }

    @Override
    public void setBD(int value) {
        if (value > 1) {
            throw new X13Exception("BD must be <= " + Integer.toString(1));
        }
        super.setBD(value);
    }

    @Override
    public void setBQ(int value) {
        if (value > 1) {
            throw new X13Exception("BQ must be <= " + Integer.toString(1));
        }
        super.setBQ(value);
    }
}

