/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;

public class AnsleyFilter
implements IArmaFilter {
    private Matrix m_bL;
    private Polynomial m_ar;
    private Polynomial m_ma;
    private double m_var;
    private int m_n;
    protected boolean m_wnoptimize = true;

    @Override
    public AnsleyFilter exemplar() {
        return new AnsleyFilter();
    }

    public double[] filter(IReadDataBlock y) {
        double[] e = new double[y.getLength()];
        y.copyTo(e, 0);
        int p = this.m_ar.getDegree();
        int q = this.m_ma.getDegree();
        if (this.m_wnoptimize && p == 0 && q == 0) {
            if (this.m_var != 1.0) {
                double std = Math.sqrt(this.m_var);
                int i = 0;
                while (i < e.length) {
                    int n = i++;
                    e[n] = e[n] / std;
                }
            }
            return e;
        }
        if (p > 0) {
            int i = e.length - 1;
            while (i >= p) {
                double s = 0.0;
                for (int j = 1; j <= p; ++j) {
                    s += this.m_ar.get(j) * e[i - j];
                }
                int n = i--;
                e[n] = e[n] + s;
            }
        }
        this.rsolve(e);
        return e;
    }

    @Override
    public void filter(IReadDataBlock y, DataBlock yf) {
        double[] e = this.filter(y);
        yf.copyFrom(e, 0);
    }

    @Override
    public double getLogDeterminant() {
        if (this.m_bL == null) {
            return (double)this.m_n * Math.log(this.m_var);
        }
        DataBlock diag = this.m_bL.row(0);
        return 2.0 * diag.sumLog().value;
    }

    @Override
    public int initialize(IArimaModel arima, int n) {
        this.m_n = n;
        this.m_bL = null;
        this.m_ar = arima.getAR().getPolynomial();
        BackFilter ma = arima.getMA();
        this.m_var = arima.getInnovationVariance();
        this.m_ma = ma.getPolynomial();
        int p = this.m_ar.getDegree();
        int q = this.m_ma.getDegree();
        if (this.m_wnoptimize && p == 0 && q == 0) {
            return n;
        }
        int r = Math.max(p, q + 1);
        double[] cov = null;
        double[] dcov = null;
        if (p > 0) {
            cov = arima.getAutoCovarianceFunction().values(r);
            double[] psi = new RationalFunction(this.m_ma, this.m_ar).coefficients(q);
            dcov = new double[r];
            for (int i = 1; i <= q; ++i) {
                double v = this.m_ma.get(i);
                for (int j = i + 1; j <= q; ++j) {
                    v += this.m_ma.get(j) * psi[j - i];
                }
                dcov[i] = v * this.m_var;
            }
        }
        Polynomial sma = SymmetricFilter.createFromFilter(ma).getPolynomial();
        if (this.m_var != 1.0) {
            sma = sma.times(this.m_var);
        }
        this.m_bL = new Matrix(r, n);
        DataBlockIterator cols = this.m_bL.columns();
        DataBlock col = cols.getData();
        for (int j = 0; j < p; ++j) {
            int i;
            for (i = 0; i < p - j; ++i) {
                col.set(i, cov[i]);
            }
            for (i = p - j; i < r; ++i) {
                col.set(i, dcov[i]);
            }
            cols.next();
        }
        SubMatrix M = this.m_bL.subMatrix(0, q + 1, p, n);
        DataBlockIterator rows = M.rows();
        DataBlock row = rows.getData();
        do {
            if (sma.get(rows.getPosition()) == 0.0) continue;
            row.set(sma.get(rows.getPosition()));
        } while (rows.next());
        this.lcholesky();
        return n;
    }

    private void lcholesky() {
        int r = this.m_bL.getRowsCount();
        int n = this.m_bL.getColumnsCount();
        double[] data = this.m_bL.internalStorage();
        if (r == 1) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] <= 0.0) {
                    throw new MatrixException("m_err_chol");
                }
                data[i] = Math.sqrt(data[i]);
            }
        } else {
            int dr = r - 1;
            int drr = dr * dr;
            int i = 0;
            int idiag = 0;
            while (i < n) {
                int rcur;
                double aii = data[idiag];
                int rmin = idiag - drr;
                if (rmin < 0) {
                    rmin = 0;
                }
                for (rcur = idiag - dr; rcur >= rmin; rcur -= dr) {
                    double x = data[rcur];
                    if (x == 0.0) continue;
                    aii -= x * x;
                }
                if (aii <= 0.0) {
                    throw new MatrixException("m_err_chol");
                }
                data[idiag] = aii = Math.sqrt(aii);
                rcur = idiag - dr;
                int k = i + r - 1;
                while (rcur >= rmin) {
                    double x = data[rcur];
                    if (x != 0.0) {
                        int q = Math.min(k, n) - i;
                        int iy = idiag + 1;
                        for (int ia = rcur + 1; ia < rcur + q; ++ia) {
                            int n2 = iy++;
                            data[n2] = data[n2] - x * data[ia];
                        }
                    }
                    rcur -= dr;
                    --k;
                }
                int ymax = r * (i + 1);
                int iy = idiag + 1;
                while (iy < ymax) {
                    int n3 = iy++;
                    data[n3] = data[n3] / aii;
                }
                ++i;
                idiag += r;
            }
        }
    }

    private void rsolve(double[] b) {
        int i;
        int n = this.m_bL.getColumnsCount();
        int r = this.m_bL.getRowsCount();
        double[] data = this.m_bL.internalStorage();
        int nb = b.length;
        for (i = 0; i < nb && b[i] == 0.0; ++i) {
        }
        int idx = i * r;
        while (i < nb) {
            double t = b[i] / data[idx];
            int jmax = Math.min(r, n - i);
            int j = 1;
            int k = idx + 1;
            while (j < jmax) {
                int n2 = i + j;
                b[n2] = b[n2] - t * data[k];
                ++j;
                ++k;
            }
            b[i] = t;
            ++i;
            idx += r;
        }
    }

    public Matrix getCholeskyFactor() {
        if (this.m_bL == null) {
            Matrix l = new Matrix(1, this.m_n);
            l.set(Math.sqrt(this.m_var));
            return l;
        }
        return this.m_bL;
    }

    public boolean isOptimizedForWhiteNoise() {
        return this.m_wnoptimize;
    }

    public void setOptimizedForWhiteNoise(boolean m_wnoptimize) {
        this.m_wnoptimize = m_wnoptimize;
    }
}

