/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;

public class TrigonometricSeries {
    private final double[] w;

    public static TrigonometricSeries regular(int periodicity) {
        int n = periodicity / 2;
        double[] freq = new double[n];
        double f = 2.0 / (double)periodicity;
        for (int i = 1; i <= n; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricSeries(freq);
    }

    public static TrigonometricSeries regular(int periodicity, int[] seasfreq) {
        double[] freq = new double[seasfreq.length];
        double f = 2.0 / (double)periodicity;
        for (int i = 0; i < seasfreq.length; ++i) {
            freq[i] = f * (double)seasfreq[i];
        }
        return new TrigonometricSeries(freq);
    }

    public static TrigonometricSeries all(double periodicity, int nfreq) {
        double[] freq = new double[nfreq];
        double f = 2.0 / periodicity;
        for (int i = 1; i <= nfreq; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricSeries(freq);
    }

    public TrigonometricSeries(double[] freq) {
        this.w = freq;
    }

    public Matrix matrix(int len) {
        return this.matrix(0, len);
    }

    public Matrix matrix(int start, int len) {
        double v;
        int nlast = this.w.length - 1;
        int n = this.w.length * 2 - (this.w[nlast] == 1.0 ? 1 : 0);
        Matrix m = new Matrix(len, n);
        int nq = n / 2;
        for (int i = 0; i < nq; ++i) {
            v = Math.PI * this.w[i];
            DataBlock c = m.column(i * 2);
            DataBlock s = m.column(i * 2 + 1);
            for (int j = 0; j < len; ++j) {
                double wj = (double)(start + j) * v;
                c.set(j, Math.cos(wj));
                s.set(j, Math.sin(wj));
            }
        }
        if (n % 2 == 1) {
            DataBlock c = m.column(2 * nlast);
            v = Math.PI * this.w[nlast];
            for (int j = 0; j < len; ++j) {
                double wj = (double)(start + j) * v;
                c.set(j, Math.cos(wj));
            }
        }
        return m;
    }
}

