/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.maths.matrices.GeneralEigenSystem;
import ec.tstoolkit.maths.matrices.IEigenSystem;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricEigenSystem;

public class EigenSystem {
    private EigenSystem() {
    }

    public static IEigenSystem create(Matrix m, boolean symmetric) {
        if (symmetric) {
            return new SymmetricEigenSystem(m);
        }
        return new GeneralEigenSystem(m);
    }

    public static IEigenSystem create(Matrix m) {
        if (EigenSystem.isSymmetric(m)) {
            return new SymmetricEigenSystem(m);
        }
        return new GeneralEigenSystem(m);
    }

    public static boolean isSymmetric(Matrix m) {
        if (m.getRowsCount() != m.getColumnsCount()) {
            return false;
        }
        for (int i = 0; i < m.getRowsCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(Math.abs(m.get(i, j) - m.get(j, i)) > 1.0E-12)) continue;
                return false;
            }
        }
        return true;
    }

    public static double[] convertToArray(Matrix m) {
        return (double[])m.data_.clone();
    }
}

