/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.SeatsException;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Map;
import java.util.Objects;

public class SeatsSpecification
implements IProcSpecification,
Cloneable {
    public static final double DEF_EPSPHI = 2.0;
    public static final double DEF_RMOD = 0.5;
    public static final double DEF_SMOD1 = 0.8;
    public static final double DEF_SMOD = 0.8;
    public static final double DEF_XL = 0.95;
    public static final int DEF_NPRED = -1;
    public static final String ADMISS = "admiss";
    public static final String METHOD = "method";
    public static final String EPSPHI = "epsphi";
    public static final String RMOD = "rmod";
    public static final String SMOD = "smod";
    public static final String SMOD1 = "stsmod";
    public static final String XL = "xl";
    public static final String NPRED = "npred";
    private double xl_ = 0.95;
    private double rmod_ = 0.5;
    private double epsPhi_ = 2.0;
    private double smod_ = 0.8;
    private double smod1_ = 0.8;
    private ApproximationMode changeModel_ = ApproximationMode.Legacy;
    private EstimationMethod method_ = EstimationMethod.Burman;
    private boolean log = false;
    private int npred = -1;
    private SarimaComponent arima;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, ADMISS), Boolean.class);
        dic.put(InformationSet.item(prefix, METHOD), String.class);
        dic.put(InformationSet.item(prefix, EPSPHI), Double.class);
        dic.put(InformationSet.item(prefix, RMOD), Double.class);
        dic.put(InformationSet.item(prefix, SMOD), Double.class);
        dic.put(InformationSet.item(prefix, SMOD1), Double.class);
        dic.put(InformationSet.item(prefix, XL), Double.class);
        dic.put(InformationSet.item(prefix, NPRED), Integer.class);
    }

    public double getXlBoundary() {
        return this.xl_;
    }

    public void setXlBoundary(double value) {
        if (value < 0.9 || value > 1.0) {
            throw new SeatsException("XL should belong to [0.9, 1]");
        }
        this.xl_ = value;
    }

    public double getSeasTolerance() {
        return this.epsPhi_;
    }

    public void setSeasTolerance(double value) {
        if (value < 0.0 || value > 10.0) {
            throw new SeatsException("EPSPHI (expressed in degrees) should belong to [0, 10]");
        }
        this.epsPhi_ = value;
    }

    public double getTrendBoundary() {
        return this.rmod_;
    }

    public void setTrendBoundary(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new SeatsException("RMOD should belong to [0, 1]");
        }
        this.rmod_ = value;
    }

    public double getSeasBoundary() {
        return this.smod_;
    }

    public void setSeasBoundary(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new SeatsException("SMOD should belong to [0, 1]");
        }
        this.smod_ = value;
    }

    public double getSeasBoundary1() {
        return this.smod1_;
    }

    public void setSeasBoundary1(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new SeatsException("SMOD1 should belong to [0, 1]");
        }
        this.smod1_ = value;
    }

    public int getPredictionLength() {
        return this.npred;
    }

    public void setPredictionLength(int npred) {
        this.npred = npred;
    }

    public boolean isDefault() {
        return this.epsPhi_ == 2.0 && this.xl_ == 0.95 && this.rmod_ == 0.5 && this.smod_ == 0.8 && this.smod1_ == 0.8 && this.changeModel_ == ApproximationMode.Legacy && this.method_ == EstimationMethod.Burman && this.npred == -1;
    }

    @Override
    public SeatsSpecification clone() {
        try {
            SeatsSpecification spec = (SeatsSpecification)super.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SeatsSpecification && this.equals((SeatsSpecification)obj);
    }

    private boolean equals(SeatsSpecification spec) {
        return spec.getApproximationMode() == this.getApproximationMode() && spec.log == this.log && spec.method_ == this.method_ && Objects.equals(spec.getArima(), this.getArima()) && spec.epsPhi_ == this.epsPhi_ && spec.rmod_ == this.rmod_ && spec.smod_ == this.smod_ && spec.smod1_ == this.smod1_ && spec.xl_ == this.xl_ && spec.npred == this.npred;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Jdk6.Double.hashCode(this.npred);
        hash = 23 * hash + Jdk6.Double.hashCode(this.xl_);
        hash = 23 * hash + Jdk6.Double.hashCode(this.rmod_);
        hash = 23 * hash + Jdk6.Double.hashCode(this.epsPhi_);
        hash = 23 * hash + (this.isLog() ? 1 : 0);
        hash = 23 * hash + Objects.hashCode(this.getArima());
        return hash;
    }

    public ApproximationMode getApproximationMode() {
        return this.changeModel_;
    }

    public void setApproximationMode(ApproximationMode changeModel) {
        this.changeModel_ = changeModel;
    }

    public EstimationMethod getMethod() {
        return this.method_;
    }

    public void setMethod(EstimationMethod method) {
        this.method_ = method;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public SarimaComponent getArima() {
        return this.arima;
    }

    public void setArima(SarimaComponent arima) {
        this.arima = arima;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.epsPhi_ != 2.0) {
            info.add(EPSPHI, Double.valueOf(this.epsPhi_));
        }
        if (verbose || this.rmod_ != 0.5) {
            info.add(RMOD, Double.valueOf(this.rmod_));
        }
        if (verbose || this.smod_ != 0.8) {
            info.add(SMOD, Double.valueOf(this.smod_));
        }
        if (verbose || this.smod1_ != 0.8) {
            info.add(SMOD1, Double.valueOf(this.smod1_));
        }
        if (verbose || this.xl_ != 0.95) {
            info.add(XL, Double.valueOf(this.xl_));
        }
        if (verbose || this.changeModel_ != ApproximationMode.Legacy) {
            info.add(ADMISS, this.changeModel_.name());
        }
        if (verbose || this.method_ != EstimationMethod.Burman) {
            info.add(METHOD, this.method_.name());
        }
        if (verbose || this.npred != -1) {
            info.add(NPRED, Integer.valueOf(this.npred));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String method;
            String admiss;
            Integer p;
            Double xl;
            Double smod1;
            Double smod;
            Double rmod;
            Double eps = info.get(EPSPHI, Double.class);
            if (eps != null) {
                this.epsPhi_ = eps;
            }
            if ((rmod = info.get(RMOD, Double.class)) != null) {
                this.rmod_ = rmod;
            }
            if ((smod = info.get(SMOD, Double.class)) != null) {
                this.smod_ = smod;
            }
            if ((smod1 = info.get(SMOD1, Double.class)) != null) {
                this.smod1_ = smod1;
            }
            if ((xl = info.get(XL, Double.class)) != null) {
                this.xl_ = xl;
            }
            if ((p = info.get(NPRED, Integer.class)) != null) {
                this.npred = p;
            }
            if ((admiss = info.get(ADMISS, String.class)) != null) {
                this.changeModel_ = ApproximationMode.valueOf(admiss);
            }
            if ((method = info.get(METHOD, String.class)) != null) {
                this.method_ = EstimationMethod.valueOf(method);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum EstimationMethod {
        Burman,
        KalmanSmoother,
        McElroyMatrix;

    }

    public static enum ApproximationMode {
        None,
        Legacy,
        Noisy;

    }
}

