% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_workspace.R
\name{get_position}
\alias{get_position}
\title{Get the position of an object}
\usage{
get_position(x, name)
}
\arguments{
\item{x}{An object containing other objects whose names we want to know}

\item{name}{a\code{character} specifiing an object}
}
\value{
A \code{integer}
}
\description{
Generic functions to retrieve the position of the contained \code{multiprocessings} or the contained  \code{sa_items}.
}
\examples{
\donttest{
spec_x13 <- x13_spec(spec = "RSA5c", easter.enabled = FALSE)
sa_x13 <- x13(ipi_c_eu[, "FR"], spec = spec_x13)
spec_ts <- tramoseats_spec(spec = "RSA5")
sa_ts <- tramoseats(ipi_c_eu[, "FR"], spec = spec_ts)

wk <- new_workspace()
mp <- new_multiprocessing(wk, "sap1")
mp2 <- new_multiprocessing(wk, "sap2")

get_position(wk, "sap1")
get_position(wk, "sap2")

add_sa_item(wk, "sap1", sa_x13, "X13")
add_sa_item(wk, "sap1", sa_ts, "TramoSeats")

get_position(mp, "TramoSeats")
get_position(mp, "X13")
}

}
\seealso{
Other functions to retrieve information from a workspace, multiprocessing or sa_item: \code{\link{get_name}}, \code{\link{get_all_names}}, \code{\link{count}}, \code{\link{get_model}}, \code{\link{get_ts}}.
}
