/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.benchmarking;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SaBenchmarkingResults
implements IProcResults {
    private final TsData orig;
    private final TsData target;
    private final TsData bench;
    public static final String ORIGINAL = "original";
    public static final String TARGET = "target";
    public static final String BENCHMARKED = "result";

    public SaBenchmarkingResults(TsData orig, TsData target, TsData bench) {
        this.orig = orig;
        this.target = target;
        this.bench = bench;
    }

    public TsData getTarget() {
        return this.target;
    }

    public TsData getBenchmarkedSeries() {
        return this.bench;
    }

    public TsData getOriginalSeries() {
        return this.orig;
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        map.put(InformationSet.item(prefix, ORIGINAL), TsData.class);
        map.put(InformationSet.item(prefix, TARGET), TsData.class);
        map.put(InformationSet.item(prefix, BENCHMARKED), TsData.class);
    }

    @Override
    public boolean contains(String id) {
        return id.equals(BENCHMARKED) || id.equals(TARGET) || id.equals(ORIGINAL);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        SaBenchmarkingResults.fillDictionary(null, dic, false);
        return dic;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (id.equals(ORIGINAL) && tclass.equals(TsData.class)) {
            return (T)this.orig;
        }
        if (id.equals(BENCHMARKED) && tclass.equals(TsData.class)) {
            return (T)this.bench;
        }
        if (id.equals(TARGET) && tclass.equals(TsData.class)) {
            return (T)this.target;
        }
        return null;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }
}

