/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.utilities.Jdk6;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CompositeSpecification
implements IProcSpecification,
Cloneable {
    private LinkedHashMap<String, Node> nodes_ = new LinkedHashMap();

    public void add(String name, Node node) {
        this.nodes_.put(name, node);
    }

    void sePartialSpecification(String part, IProcSpecification xspec) {
        Node cur = this.nodes_.get(part);
        if (cur != null) {
            this.nodes_.put(part, new Node(xspec, cur.prefix));
        }
    }

    public Set<Map.Entry<String, Node>> nodesSet() {
        return this.nodes_.entrySet();
    }

    public Set<String> keySet() {
        return this.nodes_.keySet();
    }

    public IProcSpecification search(String name) {
        Node node = this.nodes_.get(name);
        if (node == null) {
            return null;
        }
        return node.spec;
    }

    @Override
    public CompositeSpecification clone() {
        try {
            CompositeSpecification spec = (CompositeSpecification)super.clone();
            spec.nodes_ = new LinkedHashMap();
            spec.nodes_.putAll(this.nodes_);
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        for (Node cur : this.nodes_.values()) {
            InformationSet sinfo;
            if (Jdk6.isNullOrEmpty(cur.prefix)) {
                sinfo = cur.spec.write(verbose);
                if (sinfo == null) continue;
                info.merge(sinfo);
                continue;
            }
            sinfo = cur.spec.write(verbose);
            if (sinfo == null) continue;
            info.add(cur.prefix, sinfo);
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        boolean ok = true;
        for (Node cur : this.nodes_.values()) {
            String cprefix = cur.prefix;
            if (Jdk6.isNullOrEmpty(cprefix)) {
                if (cur.spec.read(info)) continue;
                ok = false;
                continue;
            }
            InformationSet sinfo = info.getSubSet(cprefix);
            if (sinfo == null || cur.spec.read(sinfo)) continue;
            ok = false;
        }
        return ok;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CompositeSpecification && this.equals((CompositeSpecification)obj);
    }

    private boolean equals(CompositeSpecification spec) {
        return Objects.equals(spec.nodes_, this.nodes_);
    }

    public static class Node {
        public final IProcSpecification spec;
        public final String prefix;

        public Node(IProcSpecification spec, String prefix) {
            this.spec = spec;
            this.prefix = prefix;
        }
    }
}

