/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LanguagePriorityList;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CodelistParser
implements Parser<Codelist> {
    private static final String sourceClass = CodelistParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String CODELIST = "Codelist";
    static final String CODE = "Code";
    static final String ID = "id";
    static final String DESCRIPTION = "Name";
    static final String PARENT = "Parent";
    static final String REF = "Ref";

    @Override
    public Codelist parse(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        return CodelistParser.parse(xMLEventReader, languagePriorityList, CODELIST, CODE, ID, DESCRIPTION);
    }

    public static Codelist parse(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList, String string, String string2, String string3, String string4) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        Codelist codelist = CodelistParser.getCodes(xMLEventReader, languagePriorityList, string, string2, string3, string4);
        logger.exiting(sourceClass, "parse");
        return codelist;
    }

    public static Codelist getCodes(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        return CodelistParser.getCodes(xMLEventReader, languagePriorityList, CODELIST, CODE, ID, DESCRIPTION);
    }

    public static Codelist getCodes(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList, String string, String string2, String string3, String string4) throws XMLStreamException, SdmxException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string5 = null;
        LocalizedText localizedText = new LocalizedText(languagePriorityList);
        boolean bl = false;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Attribute attribute;
                Iterator<Attribute> iterator;
                object = xMLEvent.asStartElement();
                if (string2.equals(object.getName().getLocalPart())) {
                    localizedText.clear();
                    string5 = null;
                    iterator = object.getAttributes();
                    while (iterator.hasNext()) {
                        attribute = iterator.next();
                        if (!string3.equals(attribute.getName().getLocalPart())) continue;
                        string5 = attribute.getValue();
                    }
                } else if (string4.equals(object.getName().getLocalPart())) {
                    localizedText.setText((StartElement)object, xMLEventReader);
                } else if (PARENT.equals(object.getName().getLocalPart())) {
                    bl = true;
                } else if (bl && REF.equals(object.getName().getLocalPart())) {
                    iterator = object.getAttributes();
                    while (iterator.hasNext()) {
                        attribute = iterator.next();
                        if (!string3.equals(attribute.getName().getLocalPart())) continue;
                        hashMap.put(string5, attribute.getValue());
                        logger.finest("PARENT: " + string5 + " = " + attribute.getValue());
                    }
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            object = xMLEvent.asEndElement().getName().getLocalPart();
            if (string2.equals(object)) {
                if (string5 != null) {
                    logger.finer("Got code " + string5 + ", " + localizedText.getText());
                    linkedHashMap.put(string5, localizedText.getText());
                    continue;
                }
                throw new SdmxXmlContentException("Error during Codelist Parsing. Invalid code id: " + string5);
            }
            if (((String)object).equals(string)) break;
            if (!PARENT.equals(object)) continue;
            bl = false;
        }
        return new Codelist(linkedHashMap, hashMap);
    }
}

