% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset09}
\alias{dataset09}
\title{dataset09}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1, 1:10, 1:200, 1], of false positives, FPs}
\item{\code{LL}}{ Ratings array [1, 1:10, 1:80, 1], of true positives, TPs}
\item{\code{lesionNum}}{ array [1:80], number of lesions per diseased case, all set to 1}
\item{\code{lesionID}}{ array [1:80, 1], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:80, 1], weights (or clinical importances) of lesions, all set to 1}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ [1] "1" modality label}
\item{\code{readerID}}{ [1:10] "1" "2" ..., reader labels}
}}
\usage{
dataset09
}
\description{
This is referred to in the book as the "NICO" dataset. It consists of 200 mammograms, 
80 of which contain one malignant mass, 
interpreted by a CAD system and nine radiologists using the 
LROC paradigm. The first reader is CAD. The highest rating method was used to convert this to an ROC 
dataset. The original LROC data is \code{datasetCadLroc}. Analyzing this \strong{one-modality}
data requires methods described in the book, specifically, the function  
\link{StSignificanceTestingSingleFixedFactor} analyzes such datasets.
}
\examples{
str(dataset09)
PlotEmpiricalOperatingCharacteristics(dataset = dataset09, rdrs = 1:10)$Plot


}
\references{
Hupse R  et al. Standalone computer-aided detection compared to radiologists' 
performance for the detection of mammographic masses. Eur Radiol. 2013;23(1):93-100.
}
\keyword{datasets}
