/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.GuardArranger;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.graph.query.ValuatorSet;

public abstract class PatternStageBase
extends Stage {
    protected static int count = 0;
    protected final ValuatorSet[] guards;
    protected final QueryTriple[] classified;
    protected final Graph graph;
    protected final QueryNodeFactory factory;

    public PatternStageBase(QueryNodeFactory factory, Graph graph, Mapping map, ExpressionSet constraints, Triple[] triples) {
        this.graph = graph;
        this.factory = factory;
        this.classified = QueryTriple.classify(factory, map, triples);
        this.guards = new GuardArranger(triples).makeGuards(map, constraints);
    }

    protected void run(Pipe source, Pipe sink, StageElement se) {
        try {
            while (this.stillOpen && source.hasNext()) {
                se.run(source.get());
            }
        }
        catch (Exception e) {
            sink.close(e);
            return;
        }
        sink.close();
    }

    public synchronized Pipe deliver(final Pipe result) {
        final Pipe stream = this.previous.deliver(new BufferPipe());
        final StageElement s = this.makeStageElementChain(result, 0);
        new Thread("PatternStage-" + ++count){

            public void run() {
                PatternStageBase.this.run(stream, result, s);
            }
        }.start();
        return result;
    }

    protected StageElement makeStageElementChain(Pipe sink, int index) {
        return index < this.classified.length ? this.makeIntermediateStageElement(sink, index) : this.makeFinalStageElement(sink);
    }

    protected StageElement.PutBindings makeFinalStageElement(Pipe sink) {
        return new StageElement.PutBindings(sink);
    }

    protected StageElement makeIntermediateStageElement(Pipe sink, int index) {
        StageElement next = this.makeNextStageElement(sink, index);
        return this.makeFindStageElement(index, next);
    }

    protected StageElement makeNextStageElement(Pipe sink, int index) {
        ValuatorSet s = this.guards[index];
        StageElement rest = this.makeStageElementChain(sink, index + 1);
        return s.isNonTrivial() ? new StageElement.RunValuatorSet(s, rest) : rest;
    }

    protected StageElement makeFindStageElement(int index, StageElement next) {
        Applyer f = this.classified[index].createApplyer(this.graph);
        Matcher m = this.classified[index].createMatcher();
        return new StageElement.FindTriples(this, m, f, next);
    }
}

