% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLumCarlo.R
\name{plot_RLumCarlo}
\alias{plot_RLumCarlo}
\title{Plot RLumCarlo Monte-Carlo Simulation Results}
\usage{
plot_RLumCarlo(
  object,
  plot_value = "mean",
  plot_uncertainty = "range",
  FUN = NULL,
  norm = FALSE,
  add = FALSE,
  ...
)
}
\arguments{
\item{object}{\link{list} of class \code{RLumCarlo_Model_Output} (\strong{required}): input object to be plotted,
usually the required input object is generated by one of the functions starting with \code{run_}.
Alternatively a list of such objects can be provided.}

\item{plot_value}{\link{character} (\emph{with default}): type of curve value to be displayed.
Allowed are \code{mean} (the default) and \code{sum} (meaningful if different systems are combined).
\code{NULL} disables the value visualisation.}

\item{plot_uncertainty}{\link{character} (\emph{with default}): type of the displayed uncertainty. Allowed
values are \code{range}, \code{sd} (standard deviation) and \code{var} (variance). \code{NULL} disables the uncertainty
visualisation.}

\item{FUN}{\link{function} (\emph{optional}): own function that can be applied to the
y-values before normalisation and plotting}

\item{norm}{\link{logical} (\emph{with default}): normalise curve to the highest intensity value}

\item{add}{\link{logical} (\emph{with default}): allows overplotting of results by adding curves to
an existing plot. This argument is handled automatically if \code{object} is of type \link{list}}

\item{\dots}{further argument, that can be passed to control the plot output largely
following the argument names in \link[graphics:plot.default]{graphics::plot.default}. Currently supported
are: \code{xlab}, \code{ylab}, \code{xlim}, \code{ylim}, \code{main}, \code{lwd}, \code{type}, \code{pch}, \code{lty},\code{col}, \code{grid}, \code{legend}.
The arguments \code{lwd}, \code{type}, \code{pch}, \code{lty}, \code{col} can be provided as a vector if \code{object} is a \link{list}}
}
\value{
This function returns a graphical output which is the visualisation of the modelling
output.
}
\description{
Visualise 'RLumCarlo' modelling results without
extracting the values manually. Typically visualised are the averaged signal
or the number of remaining electrons, with a polygon
indicating modelling uncertainties.
}
\details{
For colouring the curves, the package \link[khroma:khroma-package]{khroma::khroma-package} is used to provide colours
that can be best distinguished, in particular by colour-blind users.
}
\section{Function version}{
 0.1.0
}

\examples{
## plain plot
DELOC <- run_MC_TL_DELOC(
  s = 3.5e12,
  E = 1.45,
  R = 0.1,
  method = 'seq',
  clusters = 100,
  times = 150:350) \%T>\%
plot_RLumCarlo(legend = TRUE)

## TL with FUN to correct for thermal
## quenching
f <- function(x) x * 1/(1 + (2e+6 * exp(-0.55/(8.617e-5 * (DELOC$time + 273)))))
plot_RLumCarlo(
 object = DELOC,
 FUN = f)

}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)\cr
Johannes Friedrich, University of Bayreuth (Germany)
} 

\section{How to cite}{
Kreutzer, S., Friedrich, J., 2022. plot_RLumCarlo(): Plot RLumCarlo Monte-Carlo Simulation Results. Function version 0.1.0. In: Friedrich, J., Kreutzer, S., Pagonis, V., Schmidt, C., 2022. RLumCarlo: Monte-Carlo Methods for Simulating Luminescence Phenomena. R package version 0.1.9. https://CRAN.R-project.org/package=RLumCarlo
}

\keyword{hplot}
