% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos.R
\name{CosPdfRecovery}
\alias{CosPdfRecovery}
\title{Distribution Recovery with the COS method}
\usage{
CosPdfRecovery(x, Chf, N, a, b)
}
\arguments{
\item{x}{vector of observations}

\item{Chf}{the characteristic function}

\item{N}{the number of cos term for summation}

\item{a}{the lower limit of the truncation interval}

\item{b}{the upper limit of the truncation interval}
}
\value{
The approximated probability density of x
}
\description{
Restore the distribution with the characteristic function through the COS method, an option pricing method based on the Fourier-cosine series.
}
\examples{
N <- 32
x <- seq(-5, 5, by = 10 / (32 - 1))
a <- -6.0
b <- 6.0
CosPdfRecovery(x, StNormChf, N, a, b)
}
\references{
Fang F. and Oosterlee C.W. 2008. "A Novel Pricing Method for European Options Based on Fourier-Cosine Series Expansions", Siam Journal on Scientific Computing. 31(2): 826-848. doi: 10.1137/080718061.
}
