% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos.R
\name{LogErrorCosPdf}
\alias{LogErrorCosPdf}
\title{Calculate the Absolute Error of the COS Method}
\usage{
LogErrorCosPdf(x, f, Chf, a, b, N)
}
\arguments{
\item{x}{vector of observations}

\item{f}{the true p.d.f.}

\item{Chf}{the characteristic function}

\item{a}{the lower limit of the truncation interval}

\item{b}{the upper limit of the truncation interval}

\item{N}{the number of cos term for summation}
}
\value{
A matrix that contains the log max error for different parameters
}
\description{
Calculate the max absolute error of the cos method for different parameters given a vector of x.
}
\examples{
N <- c(1:200)
L <- c(10, 20, 60, 100, 1000)
a <- -L / 2
b <- L / 2
x <- seq(-5, 5, by = 10 / (32 - 1))
LogErrorCosPdf(x, dnorm, NormChf, a, b, N)
}
