% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_heatmap.R
\name{heatmapTikSorted}
\alias{heatmapTikSorted}
\title{Heatmap of the tik = P(Z_i=k|x_i)}
\usage{
heatmapTikSorted(output, pkg = c("ggplot2", "plotly"), ...)
}
\arguments{
\item{output}{object returned by \emph{mixtCompLearn} function from \emph{RMixtComp} or \emph{rmcMultiRun} function
from \emph{RMixtCompIO}}

\item{pkg}{"ggplot2" or "plotly". Package used to plot}

\item{...}{arguments to be passed to plot_ly}
}
\description{
Heatmap of the tik = P(Z_i=k|x_i)
}
\details{
Observation are sorted according to the hard partition then for each component
they are sorted by decreasing order of their tik's
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(
  var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
  var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
)

model <- list(
  var1 = list(type = "Gaussian", paramStr = ""),
  var2 = list(type = "Poisson", paramStr = "")
)

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

# plot
heatmapTikSorted(resLearn)

}
\seealso{
\code{\link{getTik}}

Other plot: 
\code{\link{heatmapClass}()},
\code{\link{heatmapVar}()},
\code{\link{histMisclassif}()},
\code{\link{plot.MixtComp}()},
\code{\link{plotConvergence}()},
\code{\link{plotDataBoxplot}()},
\code{\link{plotDataCI}()},
\code{\link{plotDiscrimClass}()},
\code{\link{plotDiscrimVar}()},
\code{\link{plotParamConvergence}()},
\code{\link{plotProportion}()}
}
\author{
Matthieu MARBAC
}
\concept{plot}
