/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg;

import de.hzi.infg.RequestEFetch;
import de.hzi.infg.RequestEGQuery;
import de.hzi.infg.RequestEInfo;
import de.hzi.infg.RequestELink;
import de.hzi.infg.RequestEPost;
import de.hzi.infg.RequestESearch;
import de.hzi.infg.RequestESpell;
import de.hzi.infg.RequestESummary;
import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.NoResultSoFarException;
import de.hzi.infg.exceptions.OperationNotFoundException;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.interfaces.RequestInterface;
import de.hzi.infg.interfaces.TypeInterface;
import de.hzi.infg.utilities.Utils;
import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceStub;
import gov.nih.nlm.ncbi.www.soap.eutils.egquery.EGqueryRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.einfo.EInfoRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.elink.ELinkRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.elink.ELinkResult;
import gov.nih.nlm.ncbi.www.soap.eutils.epost.EPostRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.esearch.ESearchRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.esearch.ESearchResult;
import gov.nih.nlm.ncbi.www.soap.eutils.espell.ESpellRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.esummary.ESummaryRequest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class RInterface {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String ESCAPED_BREAKWORD = "\\{bw\\}";
    public static final String BREAKWORD = "{bw}";
    public static final String SUBSET = "{ss}";
    public static final String END = "{end}";
    public static final String NCBI_PACKAGE = "gov.nih.nlm.ncbi.www.soap.eutils";
    public static final String XMLBEANS_PACKAGE = "org.apache.xmlbeans";
    public static final String EMPTY_VALUE = "empty";
    public static final String XML_ARRAY_INDICATOR = "arr";
    public static final String XML_OBJECT_INDICATOR = "obj";
    public static final String XML_ENTRY_INDICATOR = "entry";
    public static final String XML_NAME_ATTRIBUTE = "name";
    public static final String XML_LENGTH_ATTRIBUTE = "length";
    public static final int MAX_DEEP = 3;
    private static EUtilsServiceStub service;
    private Options options;
    private int proxyPort;
    private String proxyHost;
    private List<RequestInterface> opList;
    private byte lastCalled = (byte)-1;
    private boolean errorCaused = false;
    public static boolean DEBUG;
    public static boolean TIDY_XML;
    private Logger defaultLogger;
    private RequestEFetch eFetch;
    private HttpTransportProperties.ProxyProperties proxyProperties;
    private static final String[] operations;

    static {
        DEBUG = false;
        TIDY_XML = true;
        operations = new String[]{"run_eGquery", "run_eInfo", "run_eSearch", "run_eSummary", "run_eLink", "run_eSpell", "run_ePost", "run_eFetch"};
    }

    public RInterface(String proxyAddress, boolean debug, boolean tidy) {
        DEBUG = debug;
        TIDY_XML = tidy;
        this.initLogger();
        this.initRInterface();
        if (this.checkProxy(proxyAddress)) {
            this.proxyProperties = new HttpTransportProperties.ProxyProperties();
            this.proxyProperties.setProxyName(this.proxyHost);
            this.proxyProperties.setProxyPort(this.proxyPort);
            this.options.setProperty("PROXY", (Object)this.proxyProperties);
        }
    }

    private boolean checkProxy(String proxyAddress) {
        if (proxyAddress.equals("")) {
            return false;
        }
        URI tmpURI = null;
        try {
            tmpURI = new URI(proxyAddress);
        }
        catch (URISyntaxException e) {
            this.defaultLogger.debug((Object)e);
        }
        if (tmpURI != null) {
            this.proxyHost = tmpURI.getHost();
            this.proxyPort = tmpURI.getPort();
            this.defaultLogger.info((Object)("The String: " + proxyAddress));
            this.defaultLogger.info((Object)("Proxy Host: " + this.proxyHost));
            this.defaultLogger.info((Object)("Proxy Port: " + this.proxyPort));
            return true;
        }
        return false;
    }

    private void initRInterface() {
        this.opList = new ArrayList<RequestInterface>(operations.length);
        int i = 0;
        while (i < operations.length) {
            this.opList.add(i, null);
            ++i;
        }
        try {
            service = new EUtilsServiceStub();
        }
        catch (AxisFault e) {
            this.defaultLogger.debug((Object)e);
        }
        this.options = service._getServiceClient().getOptions();
        this.options.setProperty("__CHUNKED__", (Object)VALUE_FALSE);
    }

    private void initLogger() {
        this.defaultLogger = Logger.getLogger(this.getClass());
        if (DEBUG) {
            String path = System.getProperty("java.io.tmpdir");
            String logFile = String.valueOf(path) + System.getProperty("file.separator") + "rncbiplugin.log";
            System.out.println("Logging to: " + logFile);
            this.defaultLogger.setLevel(Level.DEBUG);
            String pattern = "%d{dd MMM yyyy HH:mm:ss } %m %n";
            PatternLayout layout = new PatternLayout(pattern);
            FileAppender fileApp = null;
            try {
                fileApp = new FileAppender((Layout)layout, logFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.defaultLogger.addAppender((Appender)fileApp);
        } else {
            this.defaultLogger.setLevel(Level.INFO);
        }
    }

    public void EGQueryInterface(String[] arguments) {
        this.lastCalled = 0;
        this.errorCaused = false;
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            RequestEGQuery eGQuery = new RequestEGQuery(argMap, service);
            this.opList.set(this.lastCalled, eGQuery);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void EInfoInterface(String[] arguments) {
        this.lastCalled = 1;
        this.errorCaused = false;
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            RequestEInfo eInfo = new RequestEInfo(argMap, service);
            this.opList.set(this.lastCalled, eInfo);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void ESearchInterface(String[] arguments) {
        this.lastCalled = (byte)2;
        this.errorCaused = false;
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            RequestESearch eSearch = new RequestESearch(argMap, service);
            this.opList.set(this.lastCalled, eSearch);
        }
        catch (RemoteException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void ESummaryInterface(String[] arguments) {
        this.lastCalled = (byte)3;
        this.errorCaused = false;
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            RequestESummary eSummary = new RequestESummary(argMap, service);
            this.opList.set(this.lastCalled, eSummary);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void ELinkInterface(String[] arguments) {
        this.lastCalled = (byte)4;
        this.errorCaused = false;
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            RequestELink eLink = new RequestELink(argMap, service);
            this.opList.set(this.lastCalled, eLink);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void ESpellInterface(String[] arguments) {
        this.lastCalled = (byte)5;
        this.errorCaused = false;
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            RequestESpell eSpell = new RequestESpell(argMap, service);
            this.opList.set(this.lastCalled, eSpell);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void EPostInterface(String[] arguments) {
        this.lastCalled = (byte)6;
        this.errorCaused = false;
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            RequestEPost ePost = new RequestEPost(argMap, service);
            this.opList.set(this.lastCalled, ePost);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void EFetchInterface(String[] arguments) {
        Map<String, String> argMap = this.parseArguments(arguments);
        try {
            this.eFetch.setProxyProperties(this.proxyProperties);
            this.eFetch.CallService(argMap);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public void initEFetchOperation(String db) {
        this.lastCalled = (byte)7;
        this.errorCaused = false;
        try {
            this.eFetch = new RequestEFetch(db);
            this.opList.set(this.lastCalled, this.eFetch);
        }
        catch (RemoteException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ErrorFromWebserviceExeption e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured while initializing EFetch class: ", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured while initializing EFetch class: ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured while initializing EFetch class: ", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured while initializing EFetch class: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured while initializing EFetch class: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.errorCaused = true;
            this.defaultLogger.error((Object)"Error occured while initializing EFetch class: ", (Throwable)e);
        }
    }

    private Map<String, String> parseArguments(String[] arguments) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        int i = 0;
        while (i < arguments.length) {
            argMap.put(arguments[i], arguments[i + 1]);
            i += 2;
        }
        return argMap;
    }

    public String[] getOperations() {
        return operations;
    }

    public String[] getRequestParameter(String req) {
        if (!req.startsWith("run_")) {
            req = "run_" + req;
        }
        try {
            if (req.equalsIgnoreCase(operations[0])) {
                return EGqueryRequest.getOperationParameter();
            }
            if (req.equalsIgnoreCase(operations[1])) {
                return EInfoRequest.getOperationParameter();
            }
            if (req.equalsIgnoreCase(operations[2])) {
                return ESearchRequest.getOperationParameter();
            }
            if (req.equalsIgnoreCase(operations[3])) {
                return ESummaryRequest.getOperationParameter();
            }
            if (req.equalsIgnoreCase(operations[4])) {
                return ELinkRequest.getOperationParameter();
            }
            if (req.equalsIgnoreCase(operations[5])) {
                return ESpellRequest.getOperationParameter();
            }
            if (req.equalsIgnoreCase(operations[6])) {
                return EPostRequest.getOperationParameter();
            }
            if (req.equalsIgnoreCase(operations[7])) {
                if (this.eFetch != null) {
                    return this.eFetch.getOperationParameter();
                }
                throw new IllegalStateException("No EFetch database selected yet.");
            }
            throw new OperationNotFoundException("Operation \"" + req + "\" not found");
        }
        catch (OperationNotFoundException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (IllegalStateException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        return null;
    }

    public String[] getResultParameter() {
        if (this.lastCalled == -1) {
            return null;
        }
        return this.opList.get(this.lastCalled).getParameter();
    }

    public String[] getResultParameterByName(String name) {
        try {
            if (this.lastCalled == -1) {
                throw new NoResultSoFarException("No operation yet called.");
            }
            return this.opList.get(this.lastCalled).getParameterByName(name);
        }
        catch (ParameterNotFoundException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (NoResultSoFarException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        return null;
    }

    public String[] getComplexType(String name) {
        try {
            return this.opList.get(this.lastCalled).getComplexType(name);
        }
        catch (ParameterNotFoundException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
            return null;
        }
    }

    public String getSimpleType(String name) {
        try {
            return this.opList.get(this.lastCalled).getSimpleType(name);
        }
        catch (ParameterNotFoundException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
            return null;
        }
    }

    public Map<String, TypeInterface[]> getComplexResultMap() {
        try {
            HashMap<String, TypeInterface[]> returnMap = new HashMap<String, TypeInterface[]>();
            Map<String, Object> tmpMap = this.opList.get(this.lastCalled).getResultMap();
            for (String key : tmpMap.keySet()) {
                if (tmpMap.get(key) instanceof String) continue;
                returnMap.put(key, (TypeInterface[])tmpMap.get(key));
            }
            return returnMap;
        }
        catch (NoResultSoFarException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getSimpleResultMap() {
        try {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            Map<String, Object> tmpMap = this.opList.get(this.lastCalled).getResultMap();
            for (String key : tmpMap.keySet()) {
                if (!(tmpMap.get(key) instanceof String)) continue;
                returnMap.put(key, (String)tmpMap.get(key));
            }
            return returnMap;
        }
        catch (NoResultSoFarException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> getResultMap() {
        try {
            return this.opList.get(this.lastCalled).getResultMap();
        }
        catch (NoResultSoFarException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
            return null;
        }
    }

    public boolean isDbInfo() {
        return ((RequestEInfo)this.opList.get(1)).isDbInfo();
    }

    public String[] getDbNames() {
        return ((RequestEInfo)this.opList.get(1)).getDbNames();
    }

    public boolean isErrorCaused() {
        return this.errorCaused;
    }

    public static String getBreakword() {
        return BREAKWORD;
    }

    public static String getTrue() {
        return VALUE_TRUE;
    }

    public static String getFalse() {
        return VALUE_FALSE;
    }

    public static String getSubset() {
        return SUBSET;
    }

    public static String getEmptyValue() {
        return EMPTY_VALUE;
    }

    public static String getEnd() {
        return END;
    }

    public static String getXmlArrayIndicator() {
        return XML_ARRAY_INDICATOR;
    }

    public static String getXmlObjectIndicator() {
        return XML_OBJECT_INDICATOR;
    }

    public static String getXmlEntryIndicator() {
        return XML_ENTRY_INDICATOR;
    }

    public static String getXmlNameAttribute() {
        return XML_NAME_ATTRIBUTE;
    }

    public static String getXmlLengthAttribute() {
        return XML_LENGTH_ATTRIBUTE;
    }

    public static String[] getEFetchDatabases() {
        return RequestEFetch.getDatabases();
    }

    public void setProxyUser(String username, String password) {
        this.proxyProperties.setUserName(username);
        if (!password.isEmpty()) {
            this.proxyProperties.setPassWord(password);
        }
    }

    public void storeResult(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            ObjectOutputStream out = new ObjectOutputStream(fos);
            if (filename.equalsIgnoreCase("eLinkResult")) {
                out.writeObject(((RequestELink)this.opList.get(4)).getResult());
            }
            if (filename.equalsIgnoreCase("eSearchResult")) {
                out.writeObject(((RequestESearch)this.opList.get(2)).getResult());
            }
            if (filename.equalsIgnoreCase("eFetchResult")) {
                out.writeObject(((RequestEFetch)this.opList.get(7)).getResult());
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (IOException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
    }

    public String getComplFromStoredResult(boolean elink) {
        String values = "";
        String fileName = "";
        ESearchResult sResult = null;
        ELinkResult lResult = null;
        fileName = elink ? "/home/master/work-workspace/R-NCBI-Plugin/eLinkResult" : "/home/master/work-workspace/R-NCBI-Plugin/eSearchResult";
        try {
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream oin = new ObjectInputStream(fis);
            if (elink) {
                lResult = (ELinkResult)oin.readObject();
            } else {
                sResult = (ESearchResult)oin.readObject();
            }
        }
        catch (FileNotFoundException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (IOException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.defaultLogger.error((Object)"Error occured: ", (Throwable)e);
        }
        if (elink) {
            Stack<String> sse = new Stack<String>();
            sse.push("linkset");
            values = Utils.recStructureBuild(values, lResult.getLinkSet(), new Stack<String>(), sse, false, 0);
        } else {
            Stack<String> ss = new Stack<String>();
            ss.push("translationstack");
            values = Utils.recStructureBuild(values, sResult.getTranslationStack(), new Stack<String>(), ss, false, 0);
        }
        if (values.startsWith(BREAKWORD)) {
            values = values.substring(BREAKWORD.length(), values.length());
        } else if (values.startsWith(SUBSET)) {
            values = values.substring(SUBSET.length(), values.length());
        }
        return values;
    }

    protected void finalize() throws Throwable {
        try {
            service.cleanup();
        }
        finally {
            super.finalize();
        }
    }
}

