% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_frequency.R
\name{nhanes_detection_frequency}
\alias{nhanes_detection_frequency}
\title{Compute detection frequencies of NHANES data}
\usage{
nhanes_detection_frequency(nhanes_data, column, comment_column,
  weights_column = "", filter = NULL)
}
\arguments{
\item{nhanes_data}{data frame containing NHANES data}

\item{column}{column names of the variables to compute detection frequencies for}

\item{comment_column}{comment column names of the variables to compute detection frequencies for}

\item{weights_column}{sample weight column}

\item{filter}{logical expression used to subset the data}
}
\value{
named vector of detection frequencies
}
\description{
Compute detection frequencies of NHANES data
}
\examples{

\dontrun{
dat <- nhanes_load_data("UHG_G", "2011-2012", demographics = TRUE)

# Compute detection frequency
nhanes_detection_frequency(dat, c("URXUHG"), c("URDUHGLC"))
}

}

