% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{nhanes_variables}
\alias{nhanes_variables}
\title{Load the NHANES comprehensive variable list}
\usage{
nhanes_variables(components = "all", destination = tempfile(),
  cache = TRUE)
}
\arguments{
\item{components}{one of "all", "demographics", "dietary", "examination", "laboratory", "questionnaire"}

\item{destination}{where to save the variable list}

\item{cache}{whether to cache the downloaded variable list so it doesn't have to be re-downloaded every time

Helper function for nhanes_variables function}
}
\value{
dat
}
\description{
Load the NHANES comprehensive variable list
}
\examples{
\dontrun{

# Download the comprehensive NHANES variable list
variables <- nhanes_variables()

# Download the variable list and cache it in a specific file
variables <- nhanes_variables(destination = "./nhanes_data")

}

}

