% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/appendCypher.R, R/commit.R, R/newTransaction.R
\name{appendCypher}
\alias{appendCypher}
\alias{commit}
\alias{newTransaction}
\alias{transactions}
\title{Transactions}
\usage{
appendCypher(transaction, query, ...)

commit(transaction)

newTransaction(graph)
}
\arguments{
\item{transaction}{A transaction object.}

\item{query}{A character string.}

\item{...}{A named list. Optional parameters to pass to the query in the form key = value, if applicable.}

\item{graph}{A graph object.}
}
\value{
\code{newTransaction} returns a transaction object. Both \code{appendCypher} and \code{commit} return \code{NULL}.
}
\description{
Transactions
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

data = data.frame(Origin = c("SFO", "AUS", "MCI"),
                  FlightNum = c(1, 2, 3),
                 Destination = c("PDX", "MCI", "LGA"))


query = "
MERGE (origin:Airport {name:{origin_name}})
MERGE (destination:Airport {name:{dest_name}})
CREATE (origin)<-[:ORIGIN]-(:Flight {number:{flight_num}})-[:DESTINATION]->(destination)
"

t = newTransaction(graph)

for (i in 1:nrow(data)) {
  origin_name = data[i, ]$Origin
  dest_name = data[i, ]$Dest
  flight_num = data[i, ]$FlightNum

  appendCypher(t,
               query,
               origin_name = origin_name,
               dest_name = dest_name,
               flight_num = flight_num)
}

commit(t)

cypher(graph, "MATCH (o:Airport)<-[:ORIGIN]-(f:Flight)-[:DESTINATION]->(d:Airport)
       RETURN o.name, f.number, d.name")
}
}

