% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{writeNifti}
\alias{writeNifti}
\title{Write a NIfTI-1 format file}
\usage{
writeNifti(image, file, template = NULL, datatype = "auto")
}
\arguments{
\item{image}{An image, in any acceptable form (see
\code{\link{retrieveNifti}}).}

\item{file}{A character string containing a file name.}

\item{template}{An optional template object to derive NIfTI-1 properties
from. Passed to \code{\link{updateNifti}} if \code{image} is an array.}

\item{datatype}{The NIfTI datatype to use when writing the data out. The
default, \code{"auto"} uses the R type or, for internal images, the
original datatype. Other possibilities are \code{"float"}, \code{"int16"},
etc., which may be preferred to reduce file size. However, no checks are
done to ensure that the coercion maintains precision.}
}
\description{
This function writes an image to NIfTI-1 format, using the standard NIfTI-1
C library.
}
\examples{
\dontrun{writeNifti(image, "image.nii.gz", datatype="float")}

}
\author{
Jon Clayden <code@clayden.org>
}
\references{
The NIfTI-1 standard (\url{http://nifti.nimh.nih.gov/nifti-1}).
}
\seealso{
\code{\link{readNifti}}, \code{\link{updateNifti}}
}

