% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.stats.r
\name{ROC.stats}
\alias{ROC.stats}
\title{Function to compute statistics from a confusion matrix}
\usage{
ROC.stats(outcome, predictor,cut.off='max.Youden',BR=1)
}
\arguments{
\item{outcome}{The outcome variable indicating the status in the form of a data frame or matrix. 
This variable is typically coded as 0 (positive) and 1 (negative).}

\item{predictor}{A numerical vector of scores used to predict the status of the outcome. This variable 
should be of the same length as the outcome variable (i.e., two variables are 
from the same data set and also of the same number of data rows).}

\item{cut.off}{Specification of the criterion used to select the optimal cut score. 
Three options available: (1) 'max.Youden' returns the cut score that maximizes the Youden Index (the default);
(2) 'max.sen' returns the cut score that maximizes the sensitivity; and (3) 'max.spe' returns
the cut score that maximizes the specificity.}

\item{BR}{Base rates or known prevalence. Multiple values can be specified simultaneously. 
By default BR=1.}
}
\value{
An object that contains the results.
\item{ROC.stats}{Summary and classification statistics for all participants and
all the consecutive groups. Specifically. \cr
 * N, sample size for each category. \cr
 * TP, true positives. \cr
 * FP, false positives. \cr 
 * FN, false negatives.\cr
 * TN, true negatives.\cr
 * Cut.off, the optimal cut score.\cr
 * AUC, Area under the ROC curve.\cr
 * AUC.SE, Standard error of AUC.\cr
 * AUC.low & AUC.up, '95%' confidence interval of AUC.\cr
 * Sensitivity, also true positive rate, the y-axis of the ROC.\cr
 * Specificity, also true negative rate. \cr
 * Youden.Index. \cr
 * PPV or positive predictive value for each specified base rate.\cr
 * NPV or negative predictive value for each specified base rate.\cr
 * PPV for the sample.\cr
 * NPV for the sample.\cr
 * FNR, false negative rate, or miss rate.\cr
 * FPR, false positive rate, or fall-out rate.\cr
 * FOR, false omission rate.\cr
 * FDR, false discovery rate.\cr
 * Prevalence.\cr
 * Accuracy.\cr
 * PLR, positive likelihood ratio.\cr
 * NLR, negative likelihood ratio.\cr
 * DOR, Diagnostic odds ratio.}
}
\description{
This function computes all diagnostic statistics from a confusion matrix.
}
\examples{
 
#read the example data
data(ROC.data.ex)
#run the function
ROC.stats(ROC.data.ex$outcome, ROC.data.ex$predictor,
          cut.off='max.Youden',BR=1)
}
