% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devices.R
\name{pbGetDevices}
\alias{pbGetDevices}
\alias{pbGetDevices.default}
\alias{print.pbDevices}
\alias{summary.pbDevices}
\title{Get registered Pushbullet devices}
\usage{
pbGetDevices(apikey = .getKey())

\method{pbGetDevices}{default}(apikey = .getKey())

\method{print}{pbDevices}(x, ...)

\method{summary}{pbDevices}(object, ...)
}
\arguments{
\item{apikey}{The API key used to access the service. It can be
supplied as an argument here, or via the file
\code{~/.rpushbullet.json} which is read at package
initialization.}

\item{x}{Default object for \code{print} method}

\item{...}{Other optional arguments}

\item{object}{Default object for \code{summary} method}
}
\value{
The resulting JSON record is converted to a list and
returned as a \code{pbDevices} object with appropriate
\code{print} and \code{summary} methods.
}
\description{
Retrieve the list of devices registered for the given API key.
}
\details{
This function invokes the \sQuote{devices} functionality of
the Pushbullet API; see \url{https://docs.pushbullet.com/v2/devices} for more
details.
}
\author{
Dirk Eddelbuettel
}
