% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGLS_fossil.R
\name{PGLS_fossil}
\alias{PGLS_fossil}
\title{Phylogenetic Generalized Least Square with phylogenies including
  fossils}
\usage{
PGLS_fossil(modform,data,tree=NULL,RR=NULL,...)
}
\arguments{
\item{modform}{the formula for the regression model.}

\item{data}{a list of named vectors including response and predictor
variables as named in \code{modform}.}

\item{tree}{a phylogenetic tree to be indicated for any model other than
\code{RRphylo} is used to rescale tree branches. The tree needs not to be
ultrametric and fully dichotomous.}

\item{RR}{the result of \code{RRphylo} performed on the response variable. If
\code{RR} is specified, tree branches are rescaled to the absolute
branch-wise rate values calculated by \code{RRphylo} to transform the
variance-covariance matrix.}

\item{...}{further argument passed to the function
\code{\link[phylolm]{phylolm}}.}
}
\value{
Fitted pgls parameters and significance.
}
\description{
The function performs pgls for non-ultrametric trees using a
  variety of evolutionary models or \code{\link{RRphylo}} rates to change the
  tree correlation structure.
}
\examples{
\dontrun{
library(ape)
library(phytools)

rtree(100)->tree
fastBM(tree)->resp
fastBM(tree,nsim=3)->resp.multi
fastBM(tree)->pred1
fastBM(tree)->pred2

PGLS_fossil(modform=y1~x1+x2,data=list(y1=resp,x2=pred1,x1=pred2),tree=tree)->pgls_noRR

RRphylo::RRphylo(tree,resp)->RR
PGLS_fossil(modform=y1~x1+x2,data=list(y1=resp,x2=pred1,x1=pred2),tree=tree,RR=RR)->pgls_RR

# To derive log-likelihood and AIC for PGLS_fossil outputs the function AIC can be applied
AIC(pgls_noRR)
AIC(pgls_RR)


PGLS_fossil(modform=y1~x1+x2,data=list(y1=resp.multi,x2=pred1,x1=pred2),tree=tree)->pgls2_noRR
cc<- 2/parallel::detectCores()
RRphylo::RRphylo(tree,resp.multi,clus=cc)->RR
PGLS_fossil(modform=y1~x1+x2,data=list(y1=resp.multi,x2=pred1,x1=pred2),tree=tree,RR=RR)->pgls2_RR

AIC(pgls2_noRR)
AIC(pgls2_RR)
}
}
\seealso{
\href{../doc/RRphylo.html}{\code{RRphylo} vignette}
}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro
  Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco
  Carotenuto
}
