% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{methods}
\name{dbListFields,SQLiteConnection,character-method}
\alias{dbListFields,SQLiteConnection,character-method}
\title{List fields in a table}
\usage{
\S4method{dbListFields}{SQLiteConnection,character}(conn, name, ...)
}
\arguments{
\item{conn}{An existing \code{\linkS4class{SQLiteConnection}}}

\item{name}{a length 1 character vector giving the name of a table.}

\item{...}{Needed for compatibility with generic. Otherwise ignored.}
}
\description{
Returns the fields of a given table as a character vector.
}
\examples{
library(DBI)
db <- RSQLite::datasetsDb()
dbListFields(db, "iris")
dbDisconnect(db)
}
\seealso{
The corresponding generic function \code{\link[DBI:dbListFields]{DBI::dbListFields()}}.
}

