% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stata.R
\name{stata}
\alias{stata}
\title{Send commands to a Stata process}
\usage{
stata(src = stop("At least 'src' must be specified"), data.in = NULL,
  data.out = FALSE, stata.path = getOption("RStata.StataPath",
  stop("You need to set up a Stata path; ?chooseStataBin")),
  stata.version = getOption("RStata.StataVersion",
  stop("You need to specify your Stata version")),
  stata.echo = getOption("RStata.StataEcho", TRUE), ...)
}
\arguments{
\item{src}{character vector of length 1 (path to \code{.do} file) or more
(a set of stata commands). See examples.}

\item{data.in}{\code{\link{data.frame}} to be passed to Stata}

\item{data.out}{logical value. If \code{TRUE}, the data at the end of
the Stata command are returned to R.}

\item{stata.path}{Stata command to be used}

\item{stata.version}{Version of Stata used}

\item{stata.echo}{logical value. If \code{TRUE} stata text output will be printed}

\item{...}{parameter passed to \code{\link{write.dta}}}
}
\description{
Function that sends commands to a Stata process.
}
\examples{
\dontrun{
## Single command
stata("help regress") #<- this won't work in Windows dued to needed
                      #   batch mode

## Many commands
stata_src <- '

version 10
set more off
sysuse auto
reg mpg weight

'
stata(stata_src)

## External .do file
stata("foo.do")

## Data input to Stata
x <- data.frame(a = rnorm(3), b = letters[1:3])
stata( "sum a", data.in = x)

## Data output from Stata (eg obtain 'auto' dataset)
auto <- stata("sysuse auto", data.out = TRUE)
head(auto)

## Data input/output
(y <- stata("replace a = 2", data.in = x, data.out = TRUE))
}
}

