% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readEE.R
\name{readEE}
\alias{readEE}
\title{Tidy import tool for EarthExplorer .csv export files}
\usage{
readEE(x)
}
\arguments{
\item{x}{Character, Character or list. One or more paths to EarthExplorer export files.}
}
\value{
data.frame
}
\description{
Imports CSV files exported from EarthExplorer into data.frames and annotates missing fields
}
\details{
The \href{http://earthexplorer.usgs.gov/}{EarthExplorer} CSV file can be produced from the search results page. Above the results click on 'export results' and select 'comma (,) delimited'.
}
\examples{
library(ggplot2)
ee <- readEE(system.file("external/EarthExplorer_LS8.txt", package = "RStoolbox"))

## Scenes with cloud cover < 20\%
ee[ee$Cloud.Cover < 20,]

## Available time-series
ggplot(ee) +
		geom_segment(aes(x = Date, xend = Date, y = 0, yend = 100 - Cloud.Cover,
     col = as.factor(Year))) +
		scale_y_continuous(name = "Scene quality (\% clear sky)")
}

