% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histMatch.R
\name{histMatch}
\alias{histMatch}
\title{Image to Image Contrast Matching}
\usage{
histMatch(x, ref, xmask = NULL, refmask = NULL, nSamples = 1e+05,
  intersectOnly = TRUE, paired = TRUE, forceInteger = FALSE,
  returnFunctions = FALSE, ...)
}
\arguments{
\item{x}{Raster*. Source raster which is to be modified.}

\item{ref}{Raster*. Reference raster, to which x will be matched.}

\item{xmask}{RasterLayer. Mask layer for \code{x} to exclude pixels which might distort the histogram, i.e. are not present in \code{ref}. Any NA pixel in \code{xmask} will be ignored (\code{maskvalue = NA}).}

\item{refmask}{RasterLayer. Mask layer for \code{ref}. Any NA pixel in \code{refmask} will be ignored (\code{maskvalue = NA}).}

\item{nSamples}{Integer. Number of random samples from each image to build the histograms.}

\item{intersectOnly}{Logical. If \code{TRUE} sampling will only take place in the overlap extent of the two rasters. Otherwise the full rasters will be used for sampling.}

\item{paired}{Logical. If \code{TRUE} the corresponding pixels will be used in the overlap.}

\item{forceInteger}{Logical. Force integer output.}

\item{returnFunctions}{Logical. If \code{TRUE} the matching functions will be returned instead of applying them to \code{x}.}

\item{...}{Further arguments to be passed to \link[raster]{writeRaster}.}
}
\value{
A Raster* object of \code{x} adjusted to the histogram of \code{ref}. If \code{returnFunctions  = TRUE} a list of functions (one for each layer) will be returned instead.
}
\description{
Performs image to image contrast adjustments based on histogram matching using empirical cumulative
 distribution functions from both images.
}
\note{
\code{x} and \code{ref} must have the same number of layers.
}
\examples{
library(ggplot2)
library(raster)
data(rlogo)
## Original image a (+1 to prevent log(0))
img_a <-  rlogo + 1 
## Degraded image b
img_b <- log(img_a)
## Cut-off half the image (just for better display)
img_b[, 1:50] <- NA

## Compare Images before histMatching
ggRGB(img_a,1,2,3)+
        ggRGB(img_b, 1,2,3, ggLayer = TRUE, stretch = "lin", q = 0:1) +
        geom_vline(aes(xintercept = 50))+
        ggtitle("Img_a vs. Img_b")

## Do histogram matching
img_b_matched <- histMatch(img_b, img_a)

## Compare Images after histMatching
ggRGB(img_a, 1, 2, 3)+
        ggRGB(img_b_matched, 1, 2, 3, ggLayer = TRUE, stretch = "lin", q = 0:1) +
        geom_vline(aes(xintercept = 50))+
        ggtitle("Img_a vs. Img_b_matched")

## Histogram comparison
opar <- par(mfrow = c(1, 3), no.readonly = TRUE)
img_a[,1:50] <- NA
redLayers <- stack(img_a, img_b, img_b_matched)[[c(1,4,7)]]
names(redLayers) <- c("img_a", "img_b", "img_b_matched")

hist(redLayers) 
## Reset par 
par(opar)
}
\references{
Richards and Jia: Remote Sensing Digital Image Analysis. Springer, Berlin, Heidelberg, Germany, 439pp.
}
