% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_init}
\alias{prj_init}
\title{Loads project settings without loading them into the environment.}
\usage{
prj_init(path = getwd())
}
\arguments{
\item{path}{path to start searching project base folder from. Search is
performed upwards folder structure. Should be existing directory.
(type: character, default: getwd())}
}
\value{
object of type rsuite_project
}
\description{
Loads project settings without loading them into the environment.
}
\details{
Project parameters are searched and loaded. If the project has been loaded
previously from the path the same project instance will be used without
reloading.

If the project is the first one loaded it will become the default project (used then
NULL is passed as the project for project management functions).
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj_start("my_project", skip_rc = TRUE, path = prj_base)

# init project
prj <- prj_init(path = file.path(prj_base, "my_project"))

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}},
  \code{\link{prj_install_deps}}, \code{\link{prj_load}},
  \code{\link{prj_lock_env}}, \code{\link{prj_pack}},
  \code{\link{prj_start_package}}, \code{\link{prj_start}},
  \code{\link{prj_unload}}, \code{\link{prj_zip}}
}
