% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_2.R
\name{sph.hp}
\alias{sph.hp}
\title{Hypergeometric population specificity calculation}
\usage{
sph.hp(N, n, c = 1, sp)
}
\arguments{
\item{N}{population size (scalar or vector of same length as n)}

\item{n}{sample size (scalar or vector)}

\item{c}{The cut-point number of positives to classify a cluster
as positive, default=1, if positives < c result is negative, 
>= c is positive (scalar or vector of same length as n)}

\item{sp}{test unit specificity (scalar or vector of same length as n)}
}
\value{
a vector of population-level specificities
}
\description{
Calculates population specificity for a finite population 
and imperfect test, using Hypergeometric distribution
}
\examples{
# examples of sph.hp
sph.hp(150, 30, 2, 0.98)
sph.hp(150, 30, 1, 0.98)
sph.hp(150, 1:5*10, 2, 0.98)
sph.hp(500, 30, 2, 95:100/100)
}
\keyword{methods}

